/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import java.util.Arrays;
import java.util.List;
import org.javers.common.pico.JaversModule;
import org.javers.core.exceptions.JaversException;
import org.javers.core.exceptions.JaversExceptionCode;
import org.javers.core.pico.JaversContainerFactory;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public abstract class AbstractJaversBuilder {
    private MutablePicoContainer container;

    protected <T> T getContainerComponent(Class<T> ofClass) {
        this.checkIfBuilt();
        return (T)this.container.getComponent(ofClass);
    }

    private void checkIfNotBuilt() {
        if (this.isBuilt()) {
            throw new JaversException(JaversExceptionCode.ALREADY_BUILT, new Object[0]);
        }
    }

    protected void checkIfBuilt() {
        if (!this.isBuilt()) {
            throw new JaversException(JaversExceptionCode.CONTAINER_NOT_READY, new Object[0]);
        }
    }

    protected boolean isBuilt() {
        return this.container != null;
    }

    protected PicoContainer bootContainer(JaversModule modules, Object ... beans) {
        return this.bootContainer(modules, Arrays.asList(beans));
    }

    protected PicoContainer bootContainer(JaversModule module, List<?> beans) {
        this.checkIfNotBuilt();
        this.container = JaversContainerFactory.create(Arrays.asList(module), beans);
        return this.container;
    }

    protected void addComponent(Object classOrInstance) {
        this.checkIfBuilt();
        JaversContainerFactory.addComponent(this.container, classOrInstance);
    }

    protected void addModule(JaversModule module) {
        this.checkIfBuilt();
        JaversContainerFactory.addModule(this.container, module);
    }
}

