/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.collections;

import java.util.ArrayList;
import java.util.List;
import org.javers.common.collections.Function;
import org.javers.common.collections.Predicate;
import org.javers.common.validation.Validate;

public class Lists {
    public static <T> List<T> positiveFilter(List<T> input, Predicate<T> filter) {
        Validate.argumentsAreNotNull(input, filter);
        ArrayList<T> result = new ArrayList<T>();
        for (T element : input) {
            if (!filter.apply(element)) continue;
            result.add(element);
        }
        return result;
    }

    public static <T> List<T> negativeFilter(List<T> input, Predicate<T> filter) {
        Validate.argumentsAreNotNull(input, filter);
        return Lists.positiveFilter(input, Lists.negative(filter));
    }

    public static <T> Predicate<T> negative(final Predicate<T> predicate) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T input) {
                return !predicate.apply(input);
            }
        };
    }

    public static <F, T> List<T> transform(List<F> input, Function<F, T> transformation) {
        Validate.argumentsAreNotNull(input, transformation);
        ArrayList<T> result = new ArrayList<T>();
        for (F element : input) {
            result.add(transformation.apply(element));
        }
        return result;
    }
}

