/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.pico;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.javers.common.pico.JaversModule;
import org.javers.common.validation.Validate;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.MappingStyle;
import org.javers.model.mapping.BeanBasedPropertyScanner;
import org.javers.model.mapping.EntityFactory;
import org.javers.model.mapping.EntityManager;
import org.javers.model.mapping.FieldBasedPropertyScanner;
import org.javers.model.mapping.ValueObjectFactory;
import org.javers.model.mapping.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelJaversModule
implements JaversModule {
    private static final Logger logger = LoggerFactory.getLogger(ModelJaversModule.class);
    private static Class[] moduleComponents = new Class[]{EntityManager.class, TypeMapper.class, EntityFactory.class, ValueObjectFactory.class};
    private static Map<MappingStyle, Class> propertyScannersMapping = new HashMap(){
        {
            this.put(MappingStyle.BEAN, BeanBasedPropertyScanner.class);
            this.put(MappingStyle.FIELD, FieldBasedPropertyScanner.class);
        }
    };
    private JaversCoreConfiguration javersConfiguration;

    public ModelJaversModule(JaversCoreConfiguration javersConfiguration) {
        this.javersConfiguration = javersConfiguration;
    }

    @Override
    public Collection<Class> getModuleComponents() {
        ArrayList<Class> components = new ArrayList<Class>();
        Collections.addAll(components, moduleComponents);
        this.addPropertyScanner(components);
        return components;
    }

    private void addPropertyScanner(Collection<Class> components) {
        MappingStyle mappingStyle = this.javersConfiguration.getMappingStyle();
        logger.info("using " + mappingStyle.name() + " mappingStyle");
        Validate.conditionFulfilled(propertyScannersMapping.containsKey((Object)mappingStyle), "No PropertyScanner defined for " + (Object)((Object)mappingStyle));
        components.add(propertyScannersMapping.get((Object)mappingStyle));
    }
}

