/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.domain;

import org.javers.common.validation.Validate;
import org.javers.model.domain.Diff;
import org.javers.model.domain.GlobalCdoId;

public abstract class Change {
    private Diff parent;
    private final GlobalCdoId globalCdoId;
    private Object affectedCdo;

    protected Change(GlobalCdoId globalCdoId) {
        Validate.argumentIsNotNull(globalCdoId);
        this.globalCdoId = globalCdoId;
    }

    public GlobalCdoId getGlobalCdoId() {
        return this.globalCdoId;
    }

    public Object getAffectedCdo() {
        return this.affectedCdo;
    }

    public Diff getParent() {
        return this.parent;
    }

    public void setAffectedCdo(Object affectedCdo) {
        Validate.argumentIsNotNull(affectedCdo);
        Validate.conditionFulfilled(this.affectedCdo == null, "affectedCdo already set");
        this.affectedCdo = affectedCdo;
    }

    public void bind(Diff parent) {
        Validate.conditionFulfilled(this.parent == null, "parent Diff already set");
        this.parent = parent;
    }
}

