/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.javers.common.collections.Objects;
import org.javers.common.collections.Sets;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.model.domain.changeType.ValueChange;
import org.javers.model.mapping.Property;
import org.javers.model.mapping.type.JaversType;

public class ValueChangeAppender
extends PropertyChangeAppender<ValueChange> {
    @Override
    protected Set<Class<JaversType>> getSupportedPropertyTypes() {
        return VALUE_TYPES;
    }

    @Override
    public Collection<ValueChange> calculateChanges(NodePair pair, Property property) {
        Object rightValue;
        Object leftValue = pair.getLeftPropertyValue(property);
        if (Objects.nullSafeEquals(leftValue, rightValue = pair.getRightPropertyValue(property))) {
            return Collections.EMPTY_SET;
        }
        ValueChange change = new ValueChange(pair.getGlobalCdoId(), property, leftValue, rightValue);
        return Sets.asSet(change);
    }
}

