/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javers.common.validation.Validate;
import org.javers.core.diff.NodePair;
import org.javers.model.domain.GlobalCdoId;
import org.javers.model.object.graph.ObjectNode;

public class NodeMatcher {
    public List<NodePair> match(Set<ObjectNode> leftGraph, Set<ObjectNode> rightGraph) {
        Validate.argumentsAreNotNull(leftGraph, rightGraph);
        ArrayList<NodePair> pairs = new ArrayList<NodePair>();
        Map<GlobalCdoId, ObjectNode> rightMap = this.asMap(rightGraph);
        for (ObjectNode left : leftGraph) {
            GlobalCdoId key = left.getGlobalCdoId();
            if (!rightMap.containsKey(key)) continue;
            pairs.add(new NodePair(left, rightMap.get(key)));
        }
        return pairs;
    }

    private Map<GlobalCdoId, ObjectNode> asMap(Set<ObjectNode> nodes) {
        HashMap<GlobalCdoId, ObjectNode> map = new HashMap<GlobalCdoId, ObjectNode>();
        for (ObjectNode node : nodes) {
            map.put(node.getGlobalCdoId(), node);
        }
        return map;
    }
}

