/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.javers.core.diff.DFSGraphToSetConverter;
import org.javers.core.diff.NodeMatcher;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.NewObjectAppender;
import org.javers.core.diff.appenders.NodeChangeAppender;
import org.javers.core.diff.appenders.ObjectRemovedAppender;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.model.domain.Change;
import org.javers.model.domain.Diff;
import org.javers.model.mapping.Property;
import org.javers.model.object.graph.ObjectNode;

public class DiffFactory {
    private NodeMatcher nodeMatcher;
    private DFSGraphToSetConverter graphToSetConverter;
    private List<NodeChangeAppender> nodeChangeAppenders;
    private List<PropertyChangeAppender> propertyChangeAppender;

    public DiffFactory(DFSGraphToSetConverter graphToSetConverter) {
        this.graphToSetConverter = graphToSetConverter;
        this.nodeChangeAppenders = Arrays.asList(new NewObjectAppender(), new ObjectRemovedAppender());
        this.propertyChangeAppender = Arrays.asList(new Object[0]);
        this.nodeMatcher = new NodeMatcher();
    }

    public Diff create(String userId, ObjectNode leftRoot, ObjectNode rightRoot) {
        Diff diff = new Diff(userId);
        Set<ObjectNode> leftGraph = this.graphToSetConverter.convertFromGraph(leftRoot);
        Set<ObjectNode> rightGraph = this.graphToSetConverter.convertFromGraph(rightRoot);
        for (NodeChangeAppender appender : this.nodeChangeAppenders) {
            diff.addChanges(appender.getChangeSet(leftGraph, rightGraph));
        }
        for (NodePair pair : this.nodeMatcher.match(leftGraph, rightGraph)) {
            List<Property> nodeProperties = pair.getEntity().getProperties();
            for (Property property : nodeProperties) {
                for (PropertyChangeAppender appender : this.propertyChangeAppender) {
                    Collection changes = appender.calculateChangesIfSupported(pair, property);
                    for (Change change : changes) {
                        change.setAffectedCdo(pair.getRight().getCdo().getWrappedCdo());
                        diff.addChange(change);
                    }
                }
            }
        }
        return diff;
    }
}

