/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.javers.common.pico.JaversModule;
import org.javers.common.validation.Validate;
import org.javers.core.AbstractJaversBuilder;
import org.javers.core.Javers;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.MappingStyle;
import org.javers.core.pico.CoreJaversModule;
import org.javers.model.mapping.EntityDefinition;
import org.javers.model.mapping.EntityManager;
import org.javers.model.pico.ModelJaversModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversBuilder
extends AbstractJaversBuilder {
    private static final Logger logger = LoggerFactory.getLogger(JaversBuilder.class);
    private JaversCoreConfiguration coreConfiguration;
    private Set<EntityDefinition> entityDefinitions = new HashSet<EntityDefinition>();
    private Set<Class> valueObjectClasses = new HashSet<Class>();
    private List<JaversModule> externalModules = new ArrayList<JaversModule>();

    private JaversBuilder() {
        this.coreConfiguration = new JaversCoreConfiguration();
    }

    public static JaversBuilder javers() {
        return new JaversBuilder();
    }

    public Javers build() {
        logger.info("starting up javers ...");
        this.bootContainer(this.getCoreModules(this.coreConfiguration), null);
        this.registerManagedClasses();
        this.bootEntityManager();
        logger.info("javers instance is up & ready");
        return this.getContainerComponent(Javers.class);
    }

    public JaversBuilder registerEntity(Class<?> entityClass) {
        Validate.argumentIsNotNull(entityClass);
        this.entityDefinitions.add(new EntityDefinition(entityClass));
        return this;
    }

    public JaversBuilder registerEntity(Class<?> entityClass, String idPropertyName) {
        Validate.argumentsAreNotNull(entityClass, idPropertyName);
        this.entityDefinitions.add(new EntityDefinition(entityClass, idPropertyName));
        return this;
    }

    public JaversBuilder registerValueObject(Class<?> valueObjectClass) {
        Validate.argumentIsNotNull(valueObjectClass);
        this.valueObjectClasses.add(valueObjectClass);
        return this;
    }

    public JaversBuilder registerEntity(Class<?> ... entityClasses) {
        for (Class<?> clazz : entityClasses) {
            this.registerEntity(clazz);
        }
        return this;
    }

    public JaversBuilder registerValueObject(Class<?> ... valueObjectClasses) {
        for (Class<?> clazz : valueObjectClasses) {
            this.registerValueObject(clazz);
        }
        return this;
    }

    public JaversBuilder withMappingStyle(MappingStyle mappingStyle) {
        this.coreConfiguration.withMappingStyle(mappingStyle);
        return this;
    }

    @Deprecated
    public JaversBuilder addModule(JaversModule javersModule) {
        Validate.argumentIsNotNull(javersModule);
        this.externalModules.add(javersModule);
        return this;
    }

    private List<JaversModule> getCoreModules(JaversCoreConfiguration configuration) {
        return Arrays.asList(new CoreJaversModule(), new ModelJaversModule(configuration));
    }

    private void registerManagedClasses() {
        EntityManager entityManager = this.getContainerComponent(EntityManager.class);
        for (EntityDefinition def : this.entityDefinitions) {
            entityManager.registerEntity(def);
        }
        for (Class clazz : this.valueObjectClasses) {
            entityManager.registerValueObject(clazz);
        }
    }

    private void bootEntityManager() {
        EntityManager entityManager = this.getContainerComponent(EntityManager.class);
        entityManager.buildManagedClasses();
    }
}

