/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import java.util.Arrays;
import java.util.List;
import org.javers.common.pico.JaversModule;
import org.javers.core.exceptions.JaversException;
import org.javers.core.exceptions.JaversExceptionCode;
import org.javers.core.pico.JaversContainerFactory;
import org.picocontainer.PicoContainer;

public abstract class AbstractJaversBuilder {
    private PicoContainer container;

    protected <T> T getContainerComponent(Class<T> ofClass) {
        this.checkIfBuilt();
        return (T)this.container.getComponent(ofClass);
    }

    private void checkIfNotBuilt() {
        if (this.isBuilt()) {
            throw new JaversException(JaversExceptionCode.ALREADY_BUILT, new Object[0]);
        }
    }

    protected void checkIfBuilt() {
        if (!this.isBuilt()) {
            throw new JaversException(JaversExceptionCode.CONTAINER_NOT_READY, new Object[0]);
        }
    }

    protected boolean isBuilt() {
        return this.container != null;
    }

    protected PicoContainer bootContainer(JaversModule module) {
        return this.bootContainer(Arrays.asList(module), null);
    }

    protected PicoContainer bootContainer(JaversModule module, List<?> beans) {
        return this.bootContainer(Arrays.asList(module), beans);
    }

    protected PicoContainer bootContainer(List<JaversModule> modules, List<?> beans) {
        this.checkIfNotBuilt();
        this.container = JaversContainerFactory.create(modules, beans);
        return this.container;
    }
}

