/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.javers.common.collections.Function;
import org.javers.common.validation.Validate;

public class Sets {
    private Sets() {
    }

    public static <E> Set<E> difference(Set<E> first, Set<E> second) {
        Validate.argumentIsNotNull(first);
        Validate.argumentIsNotNull(second);
        HashSet<E> difference = new HashSet<E>(first);
        difference.removeAll(second);
        return difference;
    }

    public static <E> Set<E> asSet(E ... elements) {
        return Sets.asSet(Arrays.asList(elements));
    }

    public static <E> Set<E> asSet(Collection<E> elements) {
        return new HashSet<E>(elements);
    }

    public static <F, T> Set<T> transform(Set<F> input, Function<F, T> transformation) {
        Validate.argumentIsNotNull(input);
        Validate.argumentIsNotNull(transformation);
        HashSet<T> result = new HashSet<T>();
        for (F element : input) {
            result.add(transformation.apply(element));
        }
        return result;
    }
}

