/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.test.jspec;

import org.javalite.test.jspec.DifferenceExpectation;
import org.javalite.test.jspec.ExceptionExpectation;
import org.javalite.test.jspec.Expectation;
import org.javalite.test.jspec.TestException;

public final class JSpec {
    private JSpec() {
    }

    public static Expectation<Object> a(Object o1) {
        return new Expectation<Object>(o1);
    }

    public static Expectation<Object> $(Object o1) {
        return JSpec.a(o1);
    }

    public static Expectation<Object> the(Object o1) {
        return JSpec.a(o1);
    }

    public static <T> Expectation<T> it(T o1) {
        return new Expectation<T>(o1);
    }

    public static <T> void expect(ExceptionExpectation<T> expectation) {
        JSpec.expect(expectation, null);
    }

    public static <T> void expect(Class<T> type, String message, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            if (!e.getClass().getName().equals(type.getName())) {
                throw new TestException("Expected exception: " + type + ", but instead got: " + e, e);
            }
            if (message != null && e.getMessage() != null && !e.getMessage().equals(message)) {
                throw new TestException("Expected message: <" + message + ">, but instead got: <" + e.getMessage() + ">", e);
            }
            return;
        }
        throw new TestException("Expected exception: " + type + ", but instead got nothing");
    }

    public static <T> void expect(ExceptionExpectation<T> expectation, String message) {
        try {
            expectation.exec();
        }
        catch (Exception e) {
            if (!e.getClass().getName().equals(expectation.getClazz().getName())) {
                e.printStackTrace();
                throw new TestException("Expected exception: " + expectation.getClazz() + ", but instead got: " + e);
            }
            if (message != null && e.getMessage() != null && !e.getMessage().equals(message)) {
                throw new TestException("Expected message: " + message + ", but instead got: " + e.getMessage());
            }
            return;
        }
        throw new TestException("Expected exception: " + expectation.getClazz() + ", but instead got nothing");
    }

    public static <T> void expect(DifferenceExpectation<T> expectation) {
        JSpec.a(expectation.getExpected()).shouldNotBeEqual(expectation.exec());
    }
}

