/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.common;

import java.util.concurrent.TimeUnit;

public class Wait {
    private static final long MAX_WAIT_MILLIS = 30000L;
    private static final int SLEEP_MILLIS = 100;

    public static boolean waitFor(Condition condition) {
        return Wait.waitFor(30000L, condition);
    }

    public static boolean waitFor(long durationMillis, Condition condition) {
        return Wait.waitFor(durationMillis, 100L, condition);
    }

    public static boolean waitFor(long durationMillis, long sleepMillis, Condition condition) {
        try {
            long expiry = System.currentTimeMillis() + durationMillis;
            boolean conditionSatisified = condition.isSatisfied();
            while (!conditionSatisified && System.currentTimeMillis() < expiry) {
                if (sleepMillis == 0L) {
                    Thread.yield();
                } else {
                    TimeUnit.MILLISECONDS.sleep(sleepMillis);
                }
                conditionSatisified = condition.isSatisfied();
            }
            return conditionSatisified;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static interface Condition {
        public boolean isSatisfied() throws Exception;
    }
}

