/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jspc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.commons.io.output.XmlStreamWriter;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.mojo.jspc.JspcMojoClassLoader;
import org.codehaus.mojo.jspc.compiler.JspCompiler;
import org.codehaus.mojo.jspc.compiler.JspCompilerFactory;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CompilationMojoSupport
extends AbstractMojo {
    private static final String DEFAULT_INJECT_STRING = "</web-app>";
    @Parameter(defaultValue="${project.build.directory}/jsp-source", required=true)
    File workingDirectory;
    @Parameter
    FileSet sources;
    @Parameter(defaultValue="${project.basedir}/src/main/webapp")
    File defaultSourcesDirectory;
    @Parameter(defaultValue="${project.build.directory}/web-fragment.xml", required=true)
    File webFragmentFile;
    @Parameter(defaultValue="${basedir}/src/main/webapp/WEB-INF/web.xml", required=true)
    File inputWebXml;
    @Parameter(defaultValue="${project.build.directory}/jspweb.xml", required=true)
    File outputWebXml;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    String javaEncoding = "UTF-8";
    @Parameter(defaultValue="${project.build.sourceVersion}")
    String source;
    @Parameter(defaultValue="${project.build.targetVersion}")
    String target;
    @Parameter(defaultValue="true")
    boolean compile;
    @Parameter(defaultValue="true")
    boolean includeInProject;
    @Parameter(defaultValue="</web-app>")
    String injectString;
    @Parameter(defaultValue="jsp")
    String packageName;
    @Parameter(defaultValue="0")
    int verbose;
    @Parameter(defaultValue="true")
    boolean showSuccess;
    @Parameter(defaultValue="false")
    boolean smapDumped;
    @Parameter(defaultValue="false")
    boolean smapSuppressed;
    @Parameter(defaultValue="true")
    boolean listErrors;
    @Parameter(defaultValue="false")
    boolean validateXml;
    @Parameter(defaultValue="true")
    boolean trimSpaces;
    @Parameter(defaultValue="true")
    boolean filtering;
    @Parameter(property="jspc.skip", defaultValue="false")
    boolean skip;
    @Parameter(defaultValue="true")
    boolean errorOnUseBeanInvalidClassAttribute;
    @Parameter(defaultValue="true")
    boolean caching;
    @Parameter(defaultValue="false")
    boolean genStringAsCharArray;
    @Parameter(defaultValue="true")
    boolean poolingEnabled;
    @Parameter(defaultValue="true")
    boolean classDebugInfo;
    @Parameter(defaultValue="1")
    int compileThreads;
    @Parameter(defaultValue="5")
    int compilationTimeout;
    @Component
    protected MavenProject project;
    @Component(role=MavenFileFilter.class, hint="default")
    private MavenFileFilter mavenFileFilter;
    @Component
    private MavenSession session;
    @Component
    private BuildContext buildContext;
    @Component
    private JspCompilerFactory jspCompilerFactory;

    CompilationMojoSupport() {
    }

    protected abstract List<String> getClasspathElements() throws MojoExecutionException;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean isWar;
        block22: {
            List<File> jspFiles;
            if (this.skip) {
                return;
            }
            Log log = this.getLog();
            isWar = "war".equals(this.project.getPackaging());
            if (!isWar) {
                log.warn((CharSequence)"Compiled JSPs will not be added to the project and web.xml will not be modified because the project's packaging is not 'war'.");
            }
            if (!this.includeInProject) {
                log.warn((CharSequence)"Compiled JSPs will not be added to the project and web.xml will not be modified because includeInProject is set to false.");
            }
            JspCompiler jspCompiler = this.jspCompilerFactory.createJspCompiler();
            if (this.sources == null) {
                this.sources = new FileSet();
                this.sources.setDirectory(this.defaultSourcesDirectory.getAbsolutePath());
                this.sources.setExcludes(Arrays.asList("WEB-INF/web.xml", "META-INF/**"));
            }
            jspCompiler.setWebappDirectory(this.sources.getDirectory());
            log.debug((CharSequence)("Source directory: " + this.sources.getDirectory()));
            jspCompiler.setOutputDirectory(this.workingDirectory);
            log.debug((CharSequence)("Output directory: " + this.workingDirectory));
            jspCompiler.setEncoding(this.javaEncoding);
            log.debug((CharSequence)("Encoding: " + this.javaEncoding));
            jspCompiler.setShowSuccess(this.showSuccess);
            jspCompiler.setListErrors(this.listErrors);
            jspCompiler.setWebFragmentFile(this.webFragmentFile);
            log.debug((CharSequence)("Web Fragment: " + this.webFragmentFile));
            jspCompiler.setPackageName(this.packageName);
            log.debug((CharSequence)("Package Name: " + this.packageName));
            List<String> classpathElements = this.getClasspathElements();
            jspCompiler.setClasspath(classpathElements);
            log.debug((CharSequence)("Classpath: " + classpathElements));
            if (this.sources.getIncludes() != null) {
                Scanner scanner = this.buildContext.newScanner(new File(this.sources.getDirectory()), true);
                scanner.setIncludes(this.sources.getIncludesArray());
                scanner.setExcludes(this.sources.getExcludesArray());
                scanner.addDefaultExcludes();
                scanner.scan();
                String[] includes = scanner.getIncludedFiles();
                jspFiles = new ArrayList<File>(includes.length);
                for (String it : includes) {
                    jspFiles.add(new File(this.sources.getDirectory(), it));
                }
            } else {
                jspFiles = Collections.emptyList();
            }
            jspCompiler.setSmapDumped(this.smapDumped);
            jspCompiler.setSmapSuppressed(this.smapSuppressed);
            jspCompiler.setCompile(this.compile);
            jspCompiler.setValidateXml(this.validateXml);
            jspCompiler.setTrimSpaces(this.trimSpaces);
            jspCompiler.setVerbose(this.verbose);
            jspCompiler.setErrorOnUseBeanInvalidClassAttribute(this.errorOnUseBeanInvalidClassAttribute);
            jspCompiler.setCompilerSourceVM(this.source);
            jspCompiler.setCompilerTargetVM(this.target);
            jspCompiler.setCaching(this.caching);
            jspCompiler.setGenStringAsCharArray(this.genStringAsCharArray);
            jspCompiler.setPoolingEnabled(this.poolingEnabled);
            jspCompiler.setClassDebugInfo(this.classDebugInfo);
            jspCompiler.setCompileThreads(this.compileThreads);
            jspCompiler.setCompileTimeout(TimeUnit.MINUTES.toMillis(this.compilationTimeout));
            this.workingDirectory.mkdirs();
            this.webFragmentFile.getParentFile().mkdirs();
            this.outputWebXml.getParentFile().mkdirs();
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            JspcMojoClassLoader cl = new JspcMojoClassLoader(parent);
            cl.addURL(this.findToolsJar());
            Thread.currentThread().setContextClassLoader(cl);
            try {
                if (!jspFiles.isEmpty()) {
                    log.info((CharSequence)("Compiling " + jspFiles.size() + " JSP source file" + (jspFiles.size() > 1 ? "s" : "") + " to " + this.workingDirectory));
                } else {
                    log.info((CharSequence)("Compiling JSP source files to " + this.workingDirectory));
                }
                StopWatch watch = new StopWatch();
                watch.start();
                jspCompiler.compile(jspFiles);
                log.info((CharSequence)("Compilation completed in " + watch));
            }
            catch (Exception e) {
                throw new MojoFailureException("Failed to compile JSPS", (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(parent);
            }
            for (File jspFile : jspFiles) {
                this.buildContext.refresh(jspFile);
            }
            if (!this.compile || !isWar) break block22;
            Scanner scanner = this.buildContext.newScanner(this.workingDirectory);
            scanner.addDefaultExcludes();
            scanner.setIncludes(new String[]{"**/*.class"});
            scanner.scan();
            for (String includedFile : scanner.getIncludedFiles()) {
                File s = new File(this.workingDirectory, includedFile);
                File d = new File(this.project.getBuild().getOutputDirectory(), includedFile);
                d.getParentFile().mkdirs();
                OutputStream fos = null;
                try {
                    fos = this.buildContext.newFileOutputStream(d);
                    org.apache.commons.io.FileUtils.copyFile((File)s, (OutputStream)fos);
                }
                catch (IOException e) {
                    try {
                        throw new MojoFailureException("Failed to copy '" + s + "' to '" + d + "'", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fos);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)fos);
            }
        }
        if (isWar && this.includeInProject) {
            this.writeWebXml();
            this.project.addCompileSourceRoot(this.workingDirectory.toString());
        }
    }

    private URL findToolsJar() throws MojoExecutionException {
        File javaHome = FileUtils.resolveFile((File)new File(File.pathSeparator), (String)System.getProperty("java.home"));
        ArrayList<File> toolsPaths = new ArrayList<File>();
        File file = null;
        if (SystemUtils.IS_OS_MAC_OSX) {
            file = FileUtils.resolveFile((File)javaHome, (String)"../Classes/classes.jar");
            toolsPaths.add(file);
        }
        if (file == null || !file.exists()) {
            file = FileUtils.resolveFile((File)javaHome, (String)"../lib/tools.jar");
            toolsPaths.add(file);
        }
        if (!file.exists()) {
            throw new MojoExecutionException("Could not find tools.jar at " + toolsPaths + " under java.home: " + javaHome);
        }
        this.getLog().debug((CharSequence)("Using tools.jar: " + file));
        URI fileUri = file.toURI();
        try {
            return fileUri.toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Could not generate URL from URI: " + fileUri, (Exception)e);
        }
    }

    private void writeWebXml() throws MojoExecutionException {
        if (!this.inputWebXml.exists()) {
            throw new MojoExecutionException("web.xml does not exist at: " + this.inputWebXml);
        }
        if (!this.webFragmentFile.exists()) {
            throw new MojoExecutionException("web-fragment.xml does not exist at: " + this.webFragmentFile);
        }
        String webXml = this.readXmlToString(this.inputWebXml);
        if (webXml.indexOf(this.injectString) == -1) {
            throw new MojoExecutionException("web.xml does not contain inject string '" + this.injectString + "' - " + this.webFragmentFile);
        }
        this.getLog().debug((CharSequence)("Injecting " + this.webFragmentFile + " into " + this.inputWebXml + " and copying to " + this.outputWebXml));
        String fragmentXml = this.readXmlToString(this.webFragmentFile);
        String output = StringUtils.replace((String)webXml, (String)this.injectString, (String)fragmentXml);
        if (DEFAULT_INJECT_STRING.equals(this.injectString)) {
            output = output + DEFAULT_INJECT_STRING;
        }
        File workingWebXml = new File(this.workingDirectory, "jspweb.xml");
        XmlStreamWriter xmlStreamWriter = null;
        try {
            xmlStreamWriter = new XmlStreamWriter(workingWebXml, this.javaEncoding);
            IOUtils.write((String)output, (Writer)xmlStreamWriter);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Failed to write '" + this.outputWebXml + "' as XML file with default encoding: " + this.javaEncoding, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(xmlStreamWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)xmlStreamWriter);
        this.outputWebXml.getParentFile().mkdirs();
        MavenFileFilterRequest request = new MavenFileFilterRequest();
        request.setEncoding(this.javaEncoding);
        request.setMavenSession(this.session);
        request.setMavenProject(this.project);
        request.setFiltering(this.filtering);
        request.setFrom(workingWebXml);
        request.setTo(this.outputWebXml);
        try {
            this.mavenFileFilter.copyFile(request);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected String readXmlToString(File f) throws MojoExecutionException {
        String string;
        XmlStreamReader reader = null;
        try {
            reader = new XmlStreamReader((InputStream)new BufferedInputStream(new FileInputStream(f)), true, this.javaEncoding);
            string = IOUtils.toString((Reader)reader);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Failed to read '" + f + "' as XML file with default encoding: " + this.javaEncoding, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }
}

