/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.orm.hibernate;

import javax.persistence.Embeddable;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.jarbframework.utils.bean.PropertyReference;
import org.jarbframework.utils.orm.ColumnReference;
import org.jarbframework.utils.orm.SchemaMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class HibernateJpaSchemaMapper
implements SchemaMapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SessionFactory sessionFactory;

    public HibernateJpaSchemaMapper(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public HibernateJpaSchemaMapper(EntityManager entityManager) {
        this(((Session)entityManager.getDelegate()).getSessionFactory());
    }

    public HibernateJpaSchemaMapper(EntityManagerFactory entityManagerFactory) {
        this(entityManagerFactory.createEntityManager());
    }

    @Override
    public String getTableName(Class<?> beanClass) {
        String tableName = null;
        AbstractEntityPersister classMetadata = this.safelyFindClassMetadata(beanClass);
        if (classMetadata != null) {
            tableName = classMetadata.getTableName();
        }
        return tableName;
    }

    private AbstractEntityPersister safelyFindClassMetadata(Class<?> beanClass) {
        AbstractEntityPersister classMetadata = null;
        try {
            classMetadata = (AbstractEntityPersister)this.sessionFactory.getClassMetadata(beanClass);
        }
        catch (HibernateException e) {
            this.logger.debug("Could not retrieve class metadata.", (Throwable)e);
        }
        return classMetadata;
    }

    @Override
    public ColumnReference getColumnReference(PropertyReference propertyReference) {
        ColumnReference columnReference;
        block3: {
            columnReference = null;
            try {
                AbstractEntityPersister classMetadata = this.safelyFindClassMetadata(propertyReference.getBeanClass());
                if (classMetadata == null) break block3;
                String[] columnNames = classMetadata.getPropertyColumnNames(propertyReference.getPropertyName());
                if (columnNames.length == 1) {
                    columnReference = new ColumnReference(classMetadata.getTableName(), columnNames[0]);
                    break block3;
                }
                throw new IllegalStateException("Property '" + propertyReference + "' is mapped to multiple columns.");
            }
            catch (MappingException e) {
                this.logger.debug("Could not map property.", (Throwable)e);
            }
        }
        return columnReference;
    }

    @Override
    public boolean isEmbeddable(Class<?> beanClass) {
        return AnnotationUtils.findAnnotation(beanClass, Embeddable.class) != null;
    }
}

