/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.orm.hibernate;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.AbstractPostInsertGenerator;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.SequenceIdentityGenerator;
import org.hibernate.id.insert.AbstractReturningDelegate;
import org.hibernate.id.insert.IdentifierGeneratingInsert;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.type.Type;

public class DatabaseAssignedIdentifierGenerator
extends AbstractPostInsertGenerator {
    public InsertGeneratedIdentifierDelegate getInsertGeneratedIdentifierDelegate(PostInsertIdentityPersister persister, Dialect dialect, boolean isGetGeneratedKeysEnabled) {
        return new Delegate(persister, dialect);
    }

    public static class Delegate
    extends AbstractReturningDelegate {
        private final Dialect dialect;
        private final String keyColumnName;
        private final Type keyType;

        public Delegate(PostInsertIdentityPersister persister, Dialect dialect) {
            super(persister);
            this.dialect = dialect;
            String[] keyColumnNames = this.getPersister().getRootTableKeyColumnNames();
            if (keyColumnNames.length > 1) {
                throw new HibernateException("The identity generator cannot be used with multi-column keys");
            }
            this.keyColumnName = keyColumnNames[0].toUpperCase();
            this.keyType = this.getPersister().getIdentifierType();
        }

        public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert() {
            return new SequenceIdentityGenerator.NoCommentsInsert(this.dialect);
        }

        protected PreparedStatement prepare(String insertSQL, SessionImplementor session) throws SQLException {
            return session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(insertSQL, new String[]{this.keyColumnName});
        }

        protected Serializable executeAndExtract(PreparedStatement insert, SessionImplementor session) throws SQLException {
            insert.execute();
            return IdentifierGeneratorHelper.getGeneratedIdentity((ResultSet)insert.getGeneratedKeys(), (String)this.keyColumnName, (Type)this.keyType);
        }
    }
}

