/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.bean;

import org.jarbframework.utils.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessor;

public final class FlexibleBeanWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlexibleBeanWrapper.class);
    private final Object bean;
    private final BeanWrapper beanWrapper;
    private final PropertyAccessor fieldAccessor;

    public FlexibleBeanWrapper(Object bean) {
        this.bean = Asserts.notNull(bean, "Wrapped bean cannot be null.");
        this.beanWrapper = new BeanWrapperImpl(bean);
        this.fieldAccessor = new DirectFieldAccessor(bean);
    }

    public Object getPropertyValue(String propertyName) {
        Object value = null;
        try {
            value = this.doGetPropertyValue(propertyName);
        }
        catch (NullValueInNestedPathException e) {
            LOGGER.debug("Could not retrieve actual property value.", (Throwable)e);
        }
        return value;
    }

    private Object doGetPropertyValue(String propertyName) {
        if (this.beanWrapper.isReadableProperty(propertyName)) {
            return this.beanWrapper.getPropertyValue(propertyName);
        }
        return this.fieldAccessor.getPropertyValue(propertyName);
    }

    public FlexibleBeanWrapper setPropertyValue(String propertyName, Object value) {
        if (this.beanWrapper.isWritableProperty(propertyName)) {
            this.beanWrapper.setPropertyValue(propertyName, value);
        } else {
            this.fieldAccessor.setPropertyValue(propertyName, value);
        }
        return this;
    }

    public Object getWrappedBean() {
        return this.bean;
    }
}

