/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.es;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.janusgraph.diskstorage.es.ElasticSearchClient;
import org.janusgraph.diskstorage.es.ElasticSearchResponse;
import org.janusgraph.diskstorage.indexing.RawQuery;

public class ElasticSearchScroll
implements Iterator<RawQuery.Result<String>> {
    private final BlockingQueue<RawQuery.Result<String>> queue = new LinkedBlockingQueue<RawQuery.Result<String>>();
    private boolean isFinished;
    private final ElasticSearchClient client;
    private final String scrollId;
    private final int batchSize;

    public ElasticSearchScroll(ElasticSearchClient client, ElasticSearchResponse initialResponse, int nbDocByQuery) {
        this.client = client;
        this.scrollId = initialResponse.getScrollId();
        this.batchSize = nbDocByQuery;
        this.update(initialResponse);
    }

    private void update(ElasticSearchResponse response) {
        response.getResults().forEach(this.queue::add);
        this.isFinished = response.numResults() < this.batchSize;
        try {
            if (this.isFinished) {
                this.client.deleteScroll(this.scrollId);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (!this.queue.isEmpty()) {
                return true;
            }
            if (this.isFinished) {
                return false;
            }
            ElasticSearchResponse res = this.client.search(this.scrollId);
            this.update(res);
            return res.numResults() > 0;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    @Override
    public RawQuery.Result<String> next() {
        if (this.hasNext()) {
            return (RawQuery.Result)this.queue.remove();
        }
        throw new NoSuchElementException();
    }
}

