/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.binary.geoshape;

import java.util.List;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.GeoshapeTypeSerializer;
import org.janusgraph.graphdb.tinkerpop.io.binary.geoshape.PointCollectionSerializer;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class MultiPolygonSerializer
extends GeoshapeTypeSerializer {
    private static final PointCollectionSerializer pointCollectionSerializer = new PointCollectionSerializer();

    public MultiPolygonSerializer() {
        super(7);
    }

    @Override
    public Geoshape readNonNullableGeoshapeValue(Buffer buffer, GraphBinaryReader context) {
        int nrPolygons = buffer.readInt();
        ShapeFactory.MultiPolygonBuilder multiPolygonBuilder = Geoshape.getShapeFactory().multiPolygon();
        for (int i = 0; i < nrPolygons; ++i) {
            List<double[]> polygonPoints = pointCollectionSerializer.readPoints(buffer);
            ShapeFactory.PolygonBuilder polygon = Geoshape.getShapeFactory().polygon();
            for (double[] point : polygonPoints) {
                polygon.pointXY(point[0], point[1]);
            }
            multiPolygonBuilder.add(polygon);
        }
        return Geoshape.geoshape(multiPolygonBuilder.build());
    }

    @Override
    public void writeNonNullableGeoshapeValue(Geoshape geoshape, Buffer buffer, GraphBinaryWriter context) {
        Shape shape = geoshape.getShape();
        Geometry geom = ((JtsGeometry)shape).getGeom();
        int nrPolygons = geom.getNumGeometries();
        buffer.writeInt(nrPolygons);
        for (int i = 0; i < nrPolygons; ++i) {
            Geometry polygon = geom.getGeometryN(i);
            pointCollectionSerializer.writePoints(polygon.getCoordinates(), buffer);
        }
    }
}

