/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.util;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.janusgraph.diskstorage.StaticBuffer;

public class KeysGroup {
    private final Token routingToken;
    private final List<StaticBuffer> keys;
    private final List<ByteBuffer> rawKeys;

    public KeysGroup(int size, Token routingToken) {
        this.keys = new ArrayList<StaticBuffer>(size);
        this.rawKeys = new ArrayList<ByteBuffer>(size);
        this.routingToken = routingToken;
    }

    public KeysGroup(List<StaticBuffer> keys, List<ByteBuffer> rawKeys, Token routingToken) {
        this.keys = keys;
        this.rawKeys = rawKeys;
        this.routingToken = routingToken;
    }

    public List<StaticBuffer> getKeys() {
        return this.keys;
    }

    public List<ByteBuffer> getRawKeys() {
        return this.rawKeys;
    }

    public void addKey(StaticBuffer key, ByteBuffer rawKey) {
        this.keys.add(key);
        this.rawKeys.add(rawKey);
    }

    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    public int size() {
        return this.keys.size();
    }

    public Token getRoutingToken() {
        return this.routingToken;
    }
}

