/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.strategy;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.CQLStoreManager;
import org.janusgraph.diskstorage.cql.strategy.GroupedExecutionStrategy;
import org.janusgraph.diskstorage.cql.strategy.ResultFiller;
import org.janusgraph.diskstorage.cql.util.KeysGroup;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;

public class ReplicasAwareGroupedExecutionStrategy
implements GroupedExecutionStrategy {
    private final CqlSession session;
    private final CqlIdentifier keyspace;

    public ReplicasAwareGroupedExecutionStrategy(Configuration configuration, CQLStoreManager storeManager) {
        this.session = storeManager.getSession();
        this.keyspace = CqlIdentifier.fromCql((String)storeManager.getKeyspaceName());
    }

    @Override
    public <R, Q> void execute(R futureResult, Q queries, List<StaticBuffer> keys, ResultFiller<R, Q, KeysGroup> withKeysGroupingFiller, ResultFiller<R, Q, List<StaticBuffer>> withoutKeysGroupingFiller, StoreTransaction txh, int keysGroupingLimit) {
        Optional optionalTokenMap = this.session.getMetadata().getTokenMap();
        if (!optionalTokenMap.isPresent()) {
            withoutKeysGroupingFiller.execute(futureResult, queries, keys, txh);
            return;
        }
        int groupLimit = Math.min(keys.size(), keysGroupingLimit);
        TokenMap tokenMap = (TokenMap)optionalTokenMap.get();
        HashMap<Set<UUID>, KeysGroup> keyGroupBuildersByNodes = new HashMap<Set<UUID>, KeysGroup>();
        for (StaticBuffer key : keys) {
            ByteBuffer keyByteBuffer = key.asByteBuffer();
            Token token = tokenMap.newToken(new ByteBuffer[]{keyByteBuffer});
            Set<UUID> replicas = this.toReplicasUUIDs(tokenMap, token);
            if (replicas.isEmpty()) {
                withKeysGroupingFiller.execute(futureResult, queries, new KeysGroup(Collections.singletonList(key), Collections.singletonList(keyByteBuffer), token), txh);
                continue;
            }
            KeysGroup keyGroup = (KeysGroup)keyGroupBuildersByNodes.get(replicas);
            if (keyGroup == null) {
                keyGroup = new KeysGroup(groupLimit, token);
                keyGroupBuildersByNodes.put(replicas, keyGroup);
            }
            keyGroup.addKey(key, keyByteBuffer);
            if (keyGroup.size() < groupLimit) continue;
            keyGroupBuildersByNodes.put(replicas, new KeysGroup(groupLimit, token));
            withKeysGroupingFiller.execute(futureResult, queries, keyGroup, txh);
        }
        for (KeysGroup keyGroup : keyGroupBuildersByNodes.values()) {
            if (keyGroup.isEmpty()) continue;
            withKeysGroupingFiller.execute(futureResult, queries, keyGroup, txh);
        }
    }

    private Set<UUID> toReplicasUUIDs(TokenMap tokenMap, Token token) {
        Set replicas = tokenMap.getReplicas(this.keyspace, token);
        if (replicas.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<UUID> uuids = new HashSet<UUID>(replicas.size());
        for (Node node : replicas) {
            uuids.add(node.getHostId());
        }
        return uuids;
    }
}

