/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.function.mutate;

import io.vavr.collection.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.cql.CQLKeyColumnValueStore;
import org.janusgraph.diskstorage.cql.function.ColumnOperationFunction;
import org.janusgraph.diskstorage.cql.function.ConsumerWithBackendException;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.time.TimestampProvider;

public abstract class AbstractCQLMutateManyFunction {
    protected final ConsumerWithBackendException<DistributedStoreManager.MaskedTimestamp> sleepAfterWriteFunction;
    protected final Function<StoreTransaction, DistributedStoreManager.MaskedTimestamp> createMaskedTimestampFunction;
    protected final ColumnOperationFunction deletionsFunction;
    protected final ColumnOperationFunction additionsFunction;
    private final Map<String, CQLKeyColumnValueStore> openStores;

    public AbstractCQLMutateManyFunction(ConsumerWithBackendException<DistributedStoreManager.MaskedTimestamp> sleepAfterWriteFunction, boolean assignTimestamp, TimestampProvider times, Map<String, CQLKeyColumnValueStore> openStores) {
        this.openStores = openStores;
        if (assignTimestamp) {
            this.createMaskedTimestampFunction = DistributedStoreManager.MaskedTimestamp::new;
            this.sleepAfterWriteFunction = sleepAfterWriteFunction;
            this.deletionsFunction = (commitTime, keyMutations, columnValueStore, key) -> Iterator.of((Object)commitTime.getDeletionTime(times)).flatMap(deleteTime -> Iterator.ofAll((Iterable)keyMutations.getDeletions()).map(deletion -> columnValueStore.deleteColumn(key, (StaticBuffer)deletion, (Long)deleteTime)));
            this.additionsFunction = (commitTime, keyMutations, columnValueStore, key) -> Iterator.of((Object)commitTime.getAdditionTime(times)).flatMap(addTime -> Iterator.ofAll((Iterable)keyMutations.getAdditions()).map(addition -> columnValueStore.insertColumn(key, (Entry)addition, (Long)addTime)));
        } else {
            this.createMaskedTimestampFunction = txh -> null;
            this.sleepAfterWriteFunction = mustPass -> {};
            this.deletionsFunction = (commitTime, keyMutations, columnValueStore, key) -> Iterator.ofAll((Iterable)keyMutations.getDeletions()).map(deletion -> columnValueStore.deleteColumn(key, (StaticBuffer)deletion));
            this.additionsFunction = (commitTime, keyMutations, columnValueStore, key) -> Iterator.ofAll((Iterable)keyMutations.getAdditions()).map(addition -> columnValueStore.insertColumn(key, (Entry)addition));
        }
    }

    protected CQLKeyColumnValueStore getColumnValueStore(String tableName) {
        CQLKeyColumnValueStore keyColumnValueStore = this.openStores.get(tableName);
        if (keyColumnValueStore == null) {
            throw new IllegalStateException("Store cannot be found: " + tableName);
        }
        return keyColumnValueStore;
    }
}

