/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.builder;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.cql.builder.CQLProgrammaticConfigurationLoaderBuilder;

public class CQLSessionBuilder {
    public CqlSession build(Configuration configuration, String[] baseHostnames, int baseDefaultPort, Duration baseConnectionTimeoutMS, CQLProgrammaticConfigurationLoaderBuilder baseConfigurationLoaderBuilder) throws PermanentBackendException {
        ArrayList<String> contactPoints = new ArrayList<String>(baseHostnames.length);
        for (String contactPoint : baseHostnames) {
            if (!contactPoint.contains(":")) {
                contactPoint = contactPoint + ":" + baseDefaultPort;
            }
            contactPoints.add(contactPoint);
        }
        Object driverConfigLoader = (Boolean)configuration.get(CQLConfigOptions.BASE_PROGRAMMATIC_CONFIGURATION_ENABLED, new String[0]) != false ? baseConfigurationLoaderBuilder.build(configuration, contactPoints, baseConnectionTimeoutMS) : null;
        Optional<Supplier<Config>> internalConfigurationSupplier = this.getInternalConfigSupplier(configuration, driverConfigLoader == null);
        CqlSessionBuilder builder = CqlSession.builder();
        if (internalConfigurationSupplier.isPresent()) {
            DefaultDriverConfigLoader internalDriverConfigLoader = new DefaultDriverConfigLoader(internalConfigurationSupplier.get(), false);
            driverConfigLoader = driverConfigLoader == null ? internalDriverConfigLoader : DriverConfigLoader.compose((DriverConfigLoader)internalDriverConfigLoader, (DriverConfigLoader)driverConfigLoader);
        }
        if (driverConfigLoader != null) {
            builder.withConfigLoader(driverConfigLoader);
        }
        return (CqlSession)builder.build();
    }

    private Optional<Supplier<Config>> getInternalConfigSupplier(Configuration configuration, boolean withFallbackDefaultConfiguration) throws PermanentBackendException {
        URL url;
        boolean hasAnyInternalConfiguration;
        boolean hasFileConfiguration = configuration.has(CQLConfigOptions.FILE_CONFIGURATION, new String[0]);
        boolean hasResourceConfiguration = configuration.has(CQLConfigOptions.RESOURCE_CONFIGURATION, new String[0]);
        boolean hasStringConfiguration = configuration.has(CQLConfigOptions.STRING_CONFIGURATION, new String[0]);
        boolean hasUrlConfiguration = configuration.has(CQLConfigOptions.URL_CONFIGURATION, new String[0]);
        boolean bl = hasAnyInternalConfiguration = hasFileConfiguration || hasResourceConfiguration || hasStringConfiguration || hasUrlConfiguration;
        if (!hasAnyInternalConfiguration) {
            return Optional.empty();
        }
        if (hasUrlConfiguration) {
            String stringUrlRepresentation = (String)configuration.get(CQLConfigOptions.URL_CONFIGURATION, new String[0]);
            try {
                url = new URL(stringUrlRepresentation);
            }
            catch (MalformedURLException e) {
                throw new PermanentBackendException("Malformed URL: " + stringUrlRepresentation, (Throwable)e);
            }
        } else {
            url = null;
        }
        return Optional.of(() -> {
            ConfigFactory.invalidateCaches();
            Config config = ConfigFactory.defaultOverrides();
            if (hasFileConfiguration) {
                String fileConfigurationPath = (String)configuration.get(CQLConfigOptions.FILE_CONFIGURATION, new String[0]);
                config = config.withFallback((ConfigMergeable)ConfigFactory.parseFileAnySyntax((File)new File(fileConfigurationPath)));
            }
            if (hasResourceConfiguration) {
                String resourceConfigurationPath = (String)configuration.get(CQLConfigOptions.RESOURCE_CONFIGURATION, new String[0]);
                config = config.withFallback((ConfigMergeable)ConfigFactory.parseResourcesAnySyntax((String)resourceConfigurationPath, (ConfigParseOptions)ConfigParseOptions.defaults().setClassLoader(Thread.currentThread().getContextClassLoader())));
            }
            if (hasStringConfiguration) {
                String stringConfiguration = (String)configuration.get(CQLConfigOptions.STRING_CONFIGURATION, new String[0]);
                config = config.withFallback((ConfigMergeable)ConfigFactory.parseString((String)stringConfiguration));
            }
            if (hasUrlConfiguration) {
                config = config.withFallback((ConfigMergeable)ConfigFactory.parseURL((URL)url));
            }
            if (withFallbackDefaultConfiguration) {
                config = config.withFallback((ConfigMergeable)ConfigFactory.defaultReference((ClassLoader)CqlSession.class.getClassLoader()));
            }
            config = config.resolve();
            return config.getConfig("datastax-java-driver");
        });
    }
}

