/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.builder;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ExecutorServiceBuilder;
import org.janusgraph.diskstorage.configuration.ExecutorServiceConfiguration;
import org.janusgraph.diskstorage.configuration.ExecutorServiceInstrumentation;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public class CQLExecutorServiceBuilder {
    private static final AtomicLong NAME_COUNTER = new AtomicLong();

    private CQLExecutorServiceBuilder() {
    }

    public static ExecutorService buildExecutorService(Configuration configuration) {
        Integer corePoolSize = (Integer)configuration.getOrDefault(CQLConfigOptions.EXECUTOR_SERVICE_CORE_POOL_SIZE, new String[0]);
        Integer maxPoolSize = (Integer)configuration.getOrDefault(CQLConfigOptions.EXECUTOR_SERVICE_MAX_POOL_SIZE, new String[0]);
        Long keepAliveTime = (Long)configuration.getOrDefault(CQLConfigOptions.EXECUTOR_SERVICE_KEEP_ALIVE_TIME, new String[0]);
        String executorServiceClass = (String)configuration.getOrDefault(CQLConfigOptions.EXECUTOR_SERVICE_CLASS, new String[0]);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("CQLStoreManager[%02d]").build();
        if (((Boolean)configuration.get(GraphDatabaseConfiguration.BASIC_METRICS, new String[0])).booleanValue()) {
            threadFactory = ExecutorServiceInstrumentation.instrument((String)((String)configuration.get(GraphDatabaseConfiguration.METRICS_PREFIX, new String[0])), (String)("CqlStoreManager-" + NAME_COUNTER.incrementAndGet()), (ThreadFactory)threadFactory);
        }
        ExecutorServiceConfiguration executorServiceConfiguration = new ExecutorServiceConfiguration(executorServiceClass, corePoolSize, maxPoolSize, keepAliveTime, threadFactory);
        ExecutorService executorService = ExecutorServiceBuilder.build((ExecutorServiceConfiguration)executorServiceConfiguration);
        if (((Boolean)configuration.get(GraphDatabaseConfiguration.BASIC_METRICS, new String[0])).booleanValue()) {
            executorService = ExecutorServiceInstrumentation.instrument((String)((String)configuration.get(GraphDatabaseConfiguration.METRICS_PREFIX, new String[0])), (String)("CqlStoreManager-" + NAME_COUNTER.incrementAndGet()), (ExecutorService)executorService);
        }
        return executorService;
    }
}

