/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import com.datastax.oss.driver.api.core.cql.Row;
import com.google.common.collect.AbstractIterator;
import io.vavr.Tuple;
import io.vavr.Tuple3;
import io.vavr.collection.Iterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.cql.CQLColValGetter;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;

class CQLResultSetKeyIterator
extends AbstractIterator<StaticBuffer>
implements KeyIterator {
    private final SliceQuery sliceQuery;
    private final CQLColValGetter getter;
    private final Iterator<Row> iterator;
    private Row currentRow = null;
    private StaticBuffer currentKey = null;
    private StaticBuffer lastKey = null;

    CQLResultSetKeyIterator(SliceQuery sliceQuery, CQLColValGetter getter, Iterable<Row> resultSet) {
        this.sliceQuery = sliceQuery;
        this.getter = getter;
        this.iterator = Iterator.ofAll(resultSet).peek(row -> {
            this.currentRow = row;
            this.currentKey = StaticArrayBuffer.of((ByteBuffer)row.getByteBuffer("key"));
        });
    }

    protected StaticBuffer computeNext() {
        if (this.currentKey != null && !this.currentKey.equals(this.lastKey)) {
            this.lastKey = this.currentKey;
            return this.lastKey;
        }
        while (this.iterator.hasNext()) {
            this.iterator.next();
            if (this.currentKey == null || this.currentKey.equals(this.lastKey)) continue;
            this.lastKey = this.currentKey;
            return this.lastKey;
        }
        return (StaticBuffer)this.endOfData();
    }

    public RecordIterator<Entry> getEntries() {
        return new EntryRecordIterator(this.sliceQuery, this.getter, (Iterator<Row>)Iterator.of((Object)this.currentRow).concat(this.iterator), this.currentKey);
    }

    public void close() throws IOException {
    }

    static class EntryRecordIterator
    extends AbstractIterator<Entry>
    implements RecordIterator<Entry> {
        private final CQLColValGetter getter;
        private final Iterator<Tuple3<StaticBuffer, StaticBuffer, Row>> iterator;

        EntryRecordIterator(SliceQuery sliceQuery, CQLColValGetter getter, Iterator<Row> iterator, StaticBuffer key) {
            this.getter = getter;
            StaticBuffer sliceEnd = sliceQuery.getSliceEnd();
            this.iterator = iterator.map(row -> Tuple.of((Object)StaticArrayBuffer.of((ByteBuffer)row.getByteBuffer("column1")), (Object)StaticArrayBuffer.of((ByteBuffer)row.getByteBuffer("value")), (Object)row)).takeWhile(tuple -> key.equals(StaticArrayBuffer.of((ByteBuffer)((Row)tuple._3).getByteBuffer("key"))) && !sliceEnd.equals(tuple._1)).take(sliceQuery.getLimit());
        }

        protected Entry computeNext() {
            if (this.iterator.hasNext()) {
                return StaticArrayEntry.ofStaticBuffer((Object)this.iterator.next(), (StaticArrayEntry.GetColVal)this.getter);
            }
            return (Entry)this.endOfData();
        }

        public void close() throws IOException {
        }
    }
}

