/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.util.system;

public class Threads {
    public static final int DEFAULT_SLEEP_INTERVAL_MS = 100;

    public static boolean oneAlive(Thread[] threads) {
        for (Thread thread : threads) {
            if (thread == null || !thread.isAlive()) continue;
            return true;
        }
        return false;
    }

    public static void terminate(Thread[] threads) {
        for (Thread thread : threads) {
            if (thread == null || !thread.isAlive()) continue;
            thread.interrupt();
        }
    }

    public static boolean waitForCompletion(Thread[] threads) {
        return Threads.waitForCompletion(threads, Integer.MAX_VALUE);
    }

    public static boolean waitForCompletion(Thread[] threads, int maxWaitMillis) {
        return Threads.waitForCompletion(threads, maxWaitMillis, 100);
    }

    public static boolean waitForCompletion(Thread[] threads, int maxWaitMillis, int sleepPeriodMillis) {
        long endTime = System.currentTimeMillis() + (long)maxWaitMillis;
        while (Threads.oneAlive(threads)) {
            long currentTime = System.currentTimeMillis();
            if (currentTime >= endTime) {
                return false;
            }
            try {
                Thread.sleep(Math.min((long)sleepPeriodMillis, endTime - currentTime));
            }
            catch (InterruptedException e) {
                System.err.println("Interrupted while waiting for completion of threads!");
            }
        }
        return true;
    }
}

