/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types.vertices;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.IndexType;
import org.janusgraph.graphdb.types.SchemaSource;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.TypeUtil;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.graphdb.util.CollectionsUtil;

public abstract class RelationTypeVertex
extends JanusGraphSchemaVertex
implements InternalRelationType {
    private ConsistencyModifier consistency = null;
    private Integer ttl = null;
    private List<IndexType> indexes = null;

    public RelationTypeVertex(StandardJanusGraphTx tx, Object id, byte lifecycle) {
        super(tx, id, lifecycle);
    }

    @Override
    public long[] getSortKey() {
        return this.getDefinition().getValue(TypeDefinitionCategory.SORT_KEY, long[].class);
    }

    @Override
    public Order getSortOrder() {
        return this.getDefinition().getValue(TypeDefinitionCategory.SORT_ORDER, Order.class);
    }

    @Override
    public long[] getSignature() {
        return this.getDefinition().getValue(TypeDefinitionCategory.SIGNATURE, long[].class);
    }

    @Override
    public boolean isInvisibleType() {
        return this.getDefinition().getValue(TypeDefinitionCategory.INVISIBLE, Boolean.class);
    }

    @Override
    public Multiplicity multiplicity() {
        return this.getDefinition().getValue(TypeDefinitionCategory.MULTIPLICITY, Multiplicity.class);
    }

    @Override
    public ConsistencyModifier getConsistencyModifier() {
        if (this.consistency == null) {
            this.consistency = TypeUtil.getConsistencyModifier(this);
        }
        return this.consistency;
    }

    @Override
    public Integer getTTL() {
        if (null == this.ttl) {
            this.ttl = TypeUtil.getTTL(this);
        }
        return this.ttl;
    }

    @Override
    public InternalRelationType getBaseType() {
        SchemaSource.Entry entry = (SchemaSource.Entry)Iterables.getOnlyElement(this.getRelated(TypeDefinitionCategory.RELATIONTYPE_INDEX, Direction.IN), null);
        if (entry == null) {
            return null;
        }
        assert (entry.getSchemaType() instanceof InternalRelationType);
        return (InternalRelationType)((Object)entry.getSchemaType());
    }

    @Override
    public Iterable<InternalRelationType> getRelationIndexes() {
        return Iterables.concat(Collections.singletonList(this), (Iterable)Iterables.transform(this.getRelated(TypeDefinitionCategory.RELATIONTYPE_INDEX, Direction.OUT), entry -> {
            assert (entry.getSchemaType() instanceof InternalRelationType);
            return (InternalRelationType)((Object)entry.getSchemaType());
        }));
    }

    @Override
    public Iterable<IndexType> getKeyIndexes() {
        List<IndexType> result = this.indexes;
        if (result == null) {
            this.indexes = result = Collections.unmodifiableList(CollectionsUtil.toArrayList(this.getRelated(TypeDefinitionCategory.INDEX_FIELD, Direction.IN), entry -> entry.getSchemaType().asIndexType()));
        }
        assert (result != null);
        return result;
    }

    @Override
    public void resetCache() {
        super.resetCache();
        this.indexes = null;
    }
}

