/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction.subquerycache;

import java.util.List;
import java.util.concurrent.Callable;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.transaction.subquerycache.SubqueryCache;

public abstract class SubsetSubqueryCache
implements SubqueryCache {
    protected abstract SubqueryResult get(JointIndexQuery.Subquery var1);

    protected abstract void put(JointIndexQuery.Subquery var1, SubqueryResult var2);

    @Override
    public List<Object> getIfPresent(JointIndexQuery.Subquery key) {
        int limit = key.getLimit();
        JointIndexQuery.Subquery noLimitKey = key.updateLimit(0);
        SubqueryResult result = this.get(noLimitKey);
        if (result != null && (result.getQueryLimit() >= limit || result.getQueryLimit() > result.size())) {
            return result.getValues().subList(0, Math.min(limit, result.size()));
        }
        return null;
    }

    @Override
    public void put(JointIndexQuery.Subquery key, List<Object> values) {
        int limit = key.getLimit();
        JointIndexQuery.Subquery noLimitKey = key.updateLimit(0);
        this.put(noLimitKey, new SubqueryResult(values, limit));
    }

    @Override
    public List<Object> get(JointIndexQuery.Subquery key, Callable<? extends List<Object>> valueLoader) throws Exception {
        List<Object> values = this.getIfPresent(key);
        if (values == null) {
            values = valueLoader.call();
            this.put(key, values);
        }
        return values;
    }

    static class SubqueryResult {
        private List<Object> values;
        private int queryLimit;

        protected SubqueryResult(List<Object> values, int queryLimit) {
            this.values = values;
            this.queryLimit = queryLimit;
        }

        public List<Object> getValues() {
            return this.values;
        }

        public int getQueryLimit() {
            return this.queryLimit;
        }

        public int size() {
            return this.values.size();
        }
    }
}

