/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.transaction;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class VertexIterable
implements Iterable<InternalVertex> {
    private final StandardJanusGraphTx tx;
    private final StandardJanusGraph graph;

    public VertexIterable(StandardJanusGraph graph, StandardJanusGraphTx tx) {
        this.graph = graph;
        this.tx = tx;
    }

    @Override
    public Iterator<InternalVertex> iterator() {
        return new Iterator<InternalVertex>(){
            final RecordIterator<Object> iterator;
            InternalVertex nextVertex;
            {
                this.iterator = VertexIterable.this.graph.getVertexIDs(VertexIterable.this.tx.getTxHandle());
                this.nextVertex = this.nextVertex();
            }

            private InternalVertex nextVertex() {
                InternalVertex v = null;
                while (v == null && this.iterator.hasNext()) {
                    Object nextId = this.iterator.next();
                    if (IDManager.VertexIDType.Invisible.is(nextId) || !(v = VertexIterable.this.tx.getInternalVertex(nextId)).isRemoved()) continue;
                    v = null;
                }
                return v;
            }

            @Override
            public boolean hasNext() {
                return this.nextVertex != null;
            }

            @Override
            public InternalVertex next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                InternalVertex returnVertex = this.nextVertex;
                this.nextVertex = this.nextVertex();
                return returnVertex;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

