/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step.util;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;

public class PropertiesFetchingUtil {
    public static boolean isExplicitKeysPrefetchNeeded(boolean prefetchAllPropertiesRequired, Set<String> propertyKeysSet) {
        return !prefetchAllPropertiesRequired || propertyKeysSet.size() < 2;
    }

    public static <Q extends BaseVertexQuery> Q makeBasePropertiesQuery(Q query, boolean prefetchAllPropertiesRequired, Set<String> propertyKeysSet, String[] propertyKeys, QueryProfiler queryProfiler) {
        if (PropertiesFetchingUtil.isExplicitKeysPrefetchNeeded(prefetchAllPropertiesRequired, propertyKeysSet)) {
            query.keys(propertyKeys);
        }
        ((BasicVertexCentricQueryBuilder)query).profiler(queryProfiler);
        return query;
    }

    public static Iterator<? extends Property> filterPropertiesIfNeeded(Iterator<? extends Property> propertiesIt, boolean prefetchAllPropertiesRequired, Set<String> propertyKeysSet) {
        return PropertiesFetchingUtil.isExplicitKeysPrefetchNeeded(prefetchAllPropertiesRequired, propertyKeysSet) ? propertiesIt : Iterators.filter(propertiesIt, property -> propertyKeysSet.contains(property.key()));
    }
}

