/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher.FetchQueryBuildFunction;
import org.janusgraph.graphdb.tinkerpop.optimize.step.fetcher.MultiQueriableStepBatchFetcher;
import org.janusgraph.util.datastructures.ExceptionUtil;

public class HasStepBatchFetcher
extends MultiQueriableStepBatchFetcher<Boolean> {
    private final List<HasContainer> idHasContainers;
    private final List<HasContainer> labelHasContainers;
    private final List<HasContainer> propertyHasContainers;
    private final FetchQueryBuildFunction labelQueryBuilderFunction;
    private final FetchQueryBuildFunction propertiesQueryBuilderFunction;

    public HasStepBatchFetcher(List<HasContainer> idHasContainers, List<HasContainer> labelHasContainers, List<HasContainer> propertyHasContainers, int batchSize, FetchQueryBuildFunction labelQueryBuilderFunction, FetchQueryBuildFunction propertiesQueryBuilderFunction) {
        super(batchSize);
        this.idHasContainers = idHasContainers;
        this.labelHasContainers = labelHasContainers;
        this.propertyHasContainers = propertyHasContainers;
        this.labelQueryBuilderFunction = labelQueryBuilderFunction;
        this.propertiesQueryBuilderFunction = propertiesQueryBuilderFunction;
    }

    @Override
    protected Map<JanusGraphVertex, Boolean> makeQueryAndExecute(JanusGraphMultiVertexQuery multiQuery) {
        throw new IllegalStateException("makeQueryAndExecute method for HasStepBatchFetcher.java is unimplemented.");
    }

    @Override
    protected Map<JanusGraphVertex, Boolean> prefetchNextBatch(Traversal.Admin<?, ?> traversal, JanusGraphVertex requiredFetchVertex) {
        Collection<JanusGraphVertex> verticesToPrefetchProperties;
        Collection<JanusGraphVertex> verticesBatch = this.nextBatch();
        HashMap<JanusGraphVertex, Boolean> result = new HashMap<JanusGraphVertex, Boolean>(verticesBatch.size());
        Collection<JanusGraphVertex> verticesToPrefetchLabels = this.toIdPassedBatch(verticesBatch, result);
        JanusGraphVertex currentRequiredVertex = requiredFetchVertex;
        if (result.containsKey(currentRequiredVertex)) {
            currentRequiredVertex = null;
        } else if (!HasContainer.testAll((Element)currentRequiredVertex, this.idHasContainers)) {
            result.put(currentRequiredVertex, false);
            currentRequiredVertex = null;
        }
        if (verticesToPrefetchLabels.isEmpty() && currentRequiredVertex == null) {
            return result;
        }
        JanusGraphTransaction tx = JanusGraphTraversalUtil.getTx(traversal);
        if (this.labelHasContainers.isEmpty()) {
            verticesToPrefetchProperties = verticesToPrefetchLabels;
        } else {
            this.prefetchNextLabelsBatch(tx, verticesToPrefetchLabels, currentRequiredVertex);
            verticesToPrefetchProperties = new ArrayList<JanusGraphVertex>(verticesToPrefetchLabels.size());
            for (JanusGraphVertex preFetchedVertex : verticesToPrefetchLabels) {
                if (HasContainer.testAll((Element)preFetchedVertex, this.labelHasContainers)) {
                    verticesToPrefetchProperties.add(preFetchedVertex);
                    continue;
                }
                result.put(preFetchedVertex, false);
            }
            if (currentRequiredVertex != null) {
                if (result.containsKey(currentRequiredVertex)) {
                    currentRequiredVertex = null;
                } else if (!HasContainer.testAll((Element)currentRequiredVertex, this.labelHasContainers)) {
                    result.put(currentRequiredVertex, false);
                    currentRequiredVertex = null;
                }
            }
        }
        if (this.propertyHasContainers.isEmpty()) {
            for (JanusGraphVertex passedVertex : verticesToPrefetchProperties) {
                result.put(passedVertex, true);
            }
            if (currentRequiredVertex != null) {
                result.put(currentRequiredVertex, true);
            }
        } else if (!verticesToPrefetchProperties.isEmpty() || currentRequiredVertex != null) {
            this.prefetchNextPropertiesBatch(tx, verticesToPrefetchProperties, currentRequiredVertex);
            for (JanusGraphVertex preFetchedVertex : verticesToPrefetchProperties) {
                result.put(preFetchedVertex, HasContainer.testAll((Element)preFetchedVertex, this.propertyHasContainers));
            }
            if (currentRequiredVertex != null && !result.containsKey(currentRequiredVertex)) {
                result.put(currentRequiredVertex, HasContainer.testAll((Element)currentRequiredVertex, this.propertyHasContainers));
            }
        }
        return result;
    }

    private void prefetchNextLabelsBatch(JanusGraphTransaction tx, Collection<JanusGraphVertex> verticesToPrefetch, JanusGraphVertex requiredVertex) {
        JanusGraphMultiVertexQuery<? extends JanusGraphMultiVertexQuery> multiQuery = tx.multiQuery(verticesToPrefetch);
        if (requiredVertex != null) {
            multiQuery.addVertex(requiredVertex);
        }
        try {
            this.labelQueryBuilderFunction.makeQuery(multiQuery).vertices();
        }
        catch (JanusGraphException janusGraphException) {
            throw ExceptionUtil.convertIfInterrupted(janusGraphException);
        }
    }

    private void prefetchNextPropertiesBatch(JanusGraphTransaction tx, Collection<JanusGraphVertex> verticesToPrefetch, JanusGraphVertex requiredVertex) {
        JanusGraphMultiVertexQuery<? extends JanusGraphMultiVertexQuery> multiQuery = tx.multiQuery(verticesToPrefetch);
        if (requiredVertex != null) {
            multiQuery.addVertex(requiredVertex);
        }
        try {
            this.propertiesQueryBuilderFunction.makeQuery(multiQuery).preFetch();
        }
        catch (JanusGraphException janusGraphException) {
            throw ExceptionUtil.convertIfInterrupted(janusGraphException);
        }
    }

    private Collection<JanusGraphVertex> toIdPassedBatch(Collection<JanusGraphVertex> verticesBatch, Map<JanusGraphVertex, Boolean> result) {
        if (this.idHasContainers.isEmpty()) {
            return verticesBatch;
        }
        ArrayList<JanusGraphVertex> idsPassedBatch = new ArrayList<JanusGraphVertex>(verticesBatch.size());
        for (JanusGraphVertex vertexToPrefetch : verticesBatch) {
            if (HasContainer.testAll((Element)vertexToPrefetch, this.idHasContainers)) {
                idsPassedBatch.add(vertexToPrefetch);
                continue;
            }
            result.put(vertexToPrefetch, false);
        }
        return idsPassedBatch;
    }
}

