/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.graphdb.tinkerpop.optimize.step.MultiQueriable;
import org.janusgraph.graphdb.util.JanusGraphTraverserUtil;

public final class JanusGraphMultiQueryStep
extends AbstractStep<Element, Element> {
    private List<MultiQueriable> firstLoopClientSteps = new ArrayList<MultiQueriable>();
    private List<MultiQueriable> sameLoopClientSteps = new ArrayList<MultiQueriable>();
    private List<MultiQueriable> nextLoopClientSteps = new ArrayList<MultiQueriable>();
    private boolean initialized;
    private boolean limitBatchSize;
    private NoOpBarrierStep generatedBarrierStep;
    private Integer relatedBarrierStepSize;

    public JanusGraphMultiQueryStep(Traversal.Admin traversal, boolean limitBatchSize) {
        this(traversal, limitBatchSize, null, null);
    }

    public JanusGraphMultiQueryStep(Traversal.Admin traversal, boolean limitBatchSize, NoOpBarrierStep generatedBarrierStep) {
        this(traversal, limitBatchSize, generatedBarrierStep, generatedBarrierStep.getMaxBarrierSize());
    }

    public JanusGraphMultiQueryStep(Traversal.Admin traversal, boolean limitBatchSize, Integer relatedBarrierStepSize) {
        this(traversal, limitBatchSize, null, relatedBarrierStepSize);
    }

    private JanusGraphMultiQueryStep(Traversal.Admin traversal, boolean limitBatchSize, NoOpBarrierStep generatedBarrierStep, Integer relatedBarrierStepSize) {
        super(traversal);
        this.limitBatchSize = limitBatchSize;
        this.initialized = false;
        this.generatedBarrierStep = generatedBarrierStep;
        this.relatedBarrierStepSize = relatedBarrierStepSize;
    }

    public void attachFirstLoopClient(MultiQueriable mq) {
        this.firstLoopClientSteps.add(mq);
    }

    public void attachSameLoopClient(MultiQueriable mq) {
        this.sameLoopClientSteps.add(mq);
    }

    public void attachNextLoopClient(MultiQueriable mq) {
        this.nextLoopClientSteps.add(mq);
    }

    private void initialize() {
        assert (!this.initialized);
        this.initialized = true;
        if (!(this.limitBatchSize || this.sameLoopClientSteps.isEmpty() && this.nextLoopClientSteps.isEmpty() && this.firstLoopClientSteps.isEmpty())) {
            if (!this.starts.hasNext()) {
                throw FastNoSuchElementException.instance();
            }
            ArrayList elements = new ArrayList();
            this.starts.forEachRemaining(e -> {
                elements.add(e);
                this.registerTraverser((Traverser.Admin<Element>)e);
            });
            this.starts.add(elements.iterator());
        }
    }

    protected Traverser.Admin<Element> processNextStart() throws NoSuchElementException {
        if (!this.initialized) {
            this.initialize();
        }
        Traverser.Admin start = this.starts.next();
        this.registerTraverser((Traverser.Admin<Element>)start);
        return start;
    }

    private void registerTraverser(Traverser.Admin<Element> traverser) {
        if (traverser.get() instanceof Vertex) {
            Vertex vertex = (Vertex)traverser.get();
            int loops = JanusGraphTraverserUtil.getLoops(traverser);
            this.firstLoopClientSteps.forEach(client -> client.registerFirstNewLoopFutureVertexForPrefetching(vertex, loops));
            this.sameLoopClientSteps.forEach(client -> client.registerSameLoopFutureVertexForPrefetching(vertex, loops));
            this.nextLoopClientSteps.forEach(client -> client.registerNextLoopFutureVertexForPrefetching(vertex, loops));
        }
    }

    public JanusGraphMultiQueryStep clone() {
        JanusGraphMultiQueryStep clone = (JanusGraphMultiQueryStep)super.clone();
        clone.sameLoopClientSteps = new ArrayList<MultiQueriable>(this.sameLoopClientSteps);
        clone.nextLoopClientSteps = new ArrayList<MultiQueriable>(this.nextLoopClientSteps);
        clone.firstLoopClientSteps = new ArrayList<MultiQueriable>(this.firstLoopClientSteps);
        clone.limitBatchSize = this.limitBatchSize;
        clone.relatedBarrierStepSize = this.relatedBarrierStepSize;
        if (this.generatedBarrierStep != null) {
            clone.generatedBarrierStep = this.generatedBarrierStep.clone();
        }
        clone.initialized = false;
        return clone;
    }

    public void reset() {
        super.reset();
        this.initialized = false;
    }

    public boolean isLimitBatchSize() {
        return this.limitBatchSize;
    }

    public List<MultiQueriable> getFirstLoopClientSteps() {
        return Collections.unmodifiableList(this.firstLoopClientSteps);
    }

    public List<MultiQueriable> getSameLoopClientSteps() {
        return Collections.unmodifiableList(this.sameLoopClientSteps);
    }

    public List<MultiQueriable> getNextLoopClientSteps() {
        return Collections.unmodifiableList(this.nextLoopClientSteps);
    }

    public boolean isFirstLoopClientStepsEmpty() {
        return this.firstLoopClientSteps.isEmpty();
    }

    public boolean isSameLoopClientStepsEmpty() {
        return this.sameLoopClientSteps.isEmpty();
    }

    public boolean isNextLoopClientStepsEmpty() {
        return this.nextLoopClientSteps.isEmpty();
    }

    public NoOpBarrierStep getGeneratedBarrierStep() {
        return this.generatedBarrierStep;
    }

    public Optional<Integer> getRelatedBarrierStepSize() {
        return Optional.ofNullable(this.relatedBarrierStepSize);
    }
}

