/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.vertex;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.VertexList;
import org.janusgraph.graphdb.query.vertex.VertexArrayList;
import org.janusgraph.graphdb.query.vertex.VertexListInternal;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.util.IDUtils;
import org.janusgraph.util.datastructures.AbstractIdListUtil;

public class VertexIdList
implements VertexListInternal {
    public static final Comparator<Object> VERTEX_ID_COMPARATOR = IDUtils::compare;
    private final StandardJanusGraphTx tx;
    private List<Object> vertices;
    private boolean sorted;

    public VertexIdList(StandardJanusGraphTx tx) {
        this(tx, new ArrayList<Object>(10), true);
    }

    public VertexIdList(StandardJanusGraphTx tx, List<Object> vertices, boolean sorted) {
        assert (!sorted || AbstractIdListUtil.isSorted(vertices));
        this.tx = tx;
        this.vertices = vertices;
        this.sorted = sorted;
    }

    @Override
    public void add(JanusGraphVertex n) {
        if (!this.vertices.isEmpty()) {
            this.sorted = this.sorted && IDUtils.compare((Object)this.vertices.get(this.vertices.size() - 1), (Object)n.id()) <= 0;
        }
        this.vertices.add(n.id());
    }

    @Override
    public Object getID(int pos) {
        return this.vertices.get(pos);
    }

    @Override
    public List<Object> getIDs() {
        return this.vertices;
    }

    @Override
    public JanusGraphVertex get(int pos) {
        return this.tx.getInternalVertex(this.getID(pos));
    }

    @Override
    public void sort() {
        if (this.sorted) {
            return;
        }
        this.vertices.sort(VERTEX_ID_COMPARATOR);
        this.sorted = true;
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public VertexList subList(int fromPosition, int length) {
        ArrayList<Object> subList = new ArrayList<Object>(length);
        subList.addAll(this.vertices.subList(fromPosition, fromPosition + length));
        assert (subList.size() == length);
        return new VertexIdList(this.tx, subList, this.sorted);
    }

    @Override
    public int size() {
        return this.vertices.size();
    }

    @Override
    public void addAll(VertexList vertexlist) {
        List<Object> otherVertexIds;
        if (vertexlist instanceof VertexIdList) {
            otherVertexIds = ((VertexIdList)vertexlist).vertices;
        } else if (vertexlist instanceof VertexArrayList) {
            VertexArrayList other = (VertexArrayList)vertexlist;
            otherVertexIds = new ArrayList<Object>(other.size());
            for (int i = 0; i < other.size(); ++i) {
                otherVertexIds.add(other.getID(i));
            }
        } else {
            throw new IllegalArgumentException("Unsupported vertex-list: " + vertexlist.getClass());
        }
        if (this.sorted && vertexlist.isSorted()) {
            this.vertices = AbstractIdListUtil.mergeSort(this.vertices, otherVertexIds);
        } else {
            this.sorted = false;
            this.vertices.addAll(otherVertexIds);
        }
    }

    public VertexArrayList toVertexArrayList() {
        VertexArrayList list = new VertexArrayList(this.tx);
        for (int i = 0; i < this.vertices.size(); ++i) {
            list.add(this.get(i));
        }
        return list;
    }

    @Override
    public Iterator<JanusGraphVertex> iterator() {
        return new Iterator<JanusGraphVertex>(){
            private int pos = -1;

            @Override
            public boolean hasNext() {
                return this.pos + 1 < VertexIdList.this.size();
            }

            @Override
            public JanusGraphVertex next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.pos;
                return VertexIdList.this.get(this.pos);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Vertices cannot be removed from neighborhood list");
            }
        };
    }
}

