/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.graph;

import com.google.common.base.Preconditions;
import org.janusgraph.core.MixedIndexAggQuery;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.query.graph.JointIndexQuery;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.tinkerpop.optimize.step.Aggregation;

public class MixedIndexAggQueryBuilder
implements MixedIndexAggQuery {
    private final BackendTransaction txHandle;
    private final IndexSerializer serializer;
    private JointIndexQuery.Subquery query;
    private QueryProfiler profiler = QueryProfiler.NO_OP;

    public MixedIndexAggQueryBuilder(IndexSerializer serializer, BackendTransaction txHandle) {
        Preconditions.checkNotNull((Object)serializer);
        this.serializer = serializer;
        this.txHandle = txHandle;
    }

    public MixedIndexAggQueryBuilder constructIndex(JointIndexQuery indexQuery, ElementCategory resultType) {
        JointIndexQuery.Subquery subquery;
        if (indexQuery.size() != 1 || !indexQuery.getQuery(0).getIndex().isMixedIndex()) {
            return null;
        }
        this.query = subquery = indexQuery.getQuery(0);
        return this;
    }

    @Override
    public Number execute(Aggregation aggregation) {
        this.profiler.startTimer();
        this.profiler.setAnnotation("query", this.query.getMixedQuery());
        Number result = this.serializer.queryAggregation(this.query, this.txHandle, aggregation);
        this.profiler.stopTimer();
        return result;
    }

    @Override
    public void observeWith(QueryProfiler parentProfiler, boolean hasSiblings) {
        this.profiler = parentProfiler.addNested("MixedIndexCountQuery");
    }

    @Override
    public QueryProfiler getProfiler() {
        return this.profiler;
    }
}

