/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.condition;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.RelationType;
import org.janusgraph.graphdb.query.condition.Literal;

public class RelationTypeCondition<E extends JanusGraphElement>
extends Literal<E> {
    private final RelationType relationType;

    public RelationTypeCondition(RelationType relationType) {
        Preconditions.checkNotNull((Object)relationType);
        this.relationType = relationType;
    }

    @Override
    public boolean evaluate(E element) {
        Preconditions.checkArgument((boolean)(element instanceof JanusGraphRelation));
        return this.relationType.equals(((JanusGraphRelation)element).getType());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.relationType});
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other != null && this.getClass().isInstance(other) && this.relationType.equals(((RelationTypeCondition)other).relationType);
    }

    @Override
    public String toString() {
        return "type[" + this.relationType.toString() + "]";
    }
}

