/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap;

import org.janusgraph.core.JanusGraph;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.olap.GraphProvider;
import org.janusgraph.graphdb.relations.RelationCache;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.system.BaseKey;

public abstract class AbstractScanJob
implements ScanJob {
    protected final GraphProvider graph;
    protected StandardJanusGraphTx tx;
    private IDManager idManager;

    public AbstractScanJob(JanusGraph graph) {
        this.graph = new GraphProvider();
        if (graph != null) {
            this.graph.setGraph(graph);
        }
    }

    public AbstractScanJob(AbstractScanJob copy) {
        this.graph = copy.graph;
        this.tx = copy.tx;
        this.idManager = copy.idManager;
    }

    protected abstract StandardJanusGraphTx startTransaction(StandardJanusGraph var1);

    protected void open(Configuration graphConfig) {
        this.graph.initializeGraph(graphConfig);
        this.idManager = this.graph.get().getIDManager();
        this.tx = this.startTransaction(this.graph.get());
    }

    protected void close() {
        if (null != this.tx && this.tx.isOpen()) {
            this.tx.rollback();
        }
        this.graph.close();
    }

    protected boolean isGhostVertex(Object vertexId, EntryList firstEntries) {
        if (this.idManager.isPartitionedVertex(vertexId) && !this.idManager.isCanonicalVertexId(((Number)vertexId).longValue())) {
            return false;
        }
        RelationCache relCache = this.tx.getEdgeSerializer().parseRelation((Entry)firstEntries.get(0), true, this.tx);
        return relCache.typeId != BaseKey.VertexExists.longId();
    }

    protected Object getVertexId(StaticBuffer key) {
        return this.idManager.getKeyID(key);
    }

    @Override
    public abstract AbstractScanJob clone();
}

