/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import java.time.Duration;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.attribute.IntegerSerializer;
import org.janusgraph.graphdb.database.serialize.attribute.LongSerializer;

public class DurationSerializer
implements AttributeSerializer<Duration> {
    private final LongSerializer secondsSerializer = new LongSerializer();
    private final IntegerSerializer nanosSerializer = new IntegerSerializer();

    @Override
    public Duration read(ScanBuffer buffer) {
        long seconds = this.secondsSerializer.read(buffer);
        long nanos = this.nanosSerializer.read(buffer).intValue();
        return Duration.ofSeconds(seconds, nanos);
    }

    @Override
    public void write(WriteBuffer buffer, Duration attribute) {
        this.secondsSerializer.write(buffer, attribute.getSeconds());
        this.nanosSerializer.write(buffer, attribute.getNano());
    }
}

