/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.graphdb.database.util.IndexRecordUtil;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.MixedIndexType;
import org.janusgraph.graphdb.types.ParameterIndexField;

public class IndexInfoRetriever
implements KeyInformation.Retriever {
    private final StandardJanusGraphTx transaction;

    public IndexInfoRetriever(StandardJanusGraphTx tx) {
        Preconditions.checkNotNull((Object)tx);
        this.transaction = tx;
    }

    @Override
    public KeyInformation.IndexRetriever get(final String index) {
        return new KeyInformation.IndexRetriever(){
            final Map<String, KeyInformation.StoreRetriever> indexes = new ConcurrentHashMap<String, KeyInformation.StoreRetriever>();

            @Override
            public KeyInformation get(String store, String key) {
                return this.get(store).get(key);
            }

            @Override
            public KeyInformation.StoreRetriever get(String store) {
                if (this.indexes.get(store) == null) {
                    ImmutableMap infoMap;
                    Preconditions.checkNotNull((Object)IndexInfoRetriever.this.transaction, (Object)"Retriever has not been initialized");
                    MixedIndexType extIndex = IndexRecordUtil.getMixedIndex(store, IndexInfoRetriever.this.transaction);
                    assert (extIndex.getBackingIndexName().equals(index));
                    ImmutableMap.Builder b = ImmutableMap.builder();
                    for (ParameterIndexField field : extIndex.getFieldKeys()) {
                        b.put((Object)IndexRecordUtil.key2Field(field), (Object)IndexRecordUtil.getKeyInformation(field));
                    }
                    try {
                        infoMap = b.build();
                    }
                    catch (IllegalArgumentException e) {
                        throw new JanusGraphException("Duplicate index field names found, likely you have multiple properties mapped to the same index field", e);
                    }
                    KeyInformation.StoreRetriever storeRetriever = arg_0 -> ((ImmutableMap)infoMap).get(arg_0);
                    this.indexes.put(store, storeRetriever);
                }
                return this.indexes.get(store);
            }

            @Override
            public void invalidate(String store) {
                this.indexes.remove(store);
            }
        };
    }
}

