/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.configuration.converter;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.RegisteredAttributeClass;

public class RegisteredAttributeClassesConverter {
    private static RegisteredAttributeClassesConverter registeredAttributeClassesConverter;

    private RegisteredAttributeClassesConverter() {
    }

    public static RegisteredAttributeClassesConverter getInstance() {
        if (registeredAttributeClassesConverter == null) {
            registeredAttributeClassesConverter = new RegisteredAttributeClassesConverter();
        }
        return registeredAttributeClassesConverter;
    }

    public List<RegisteredAttributeClass<?>> convert(Configuration configuration) {
        Set<String> attributeIds = configuration.getContainedNamespaces(GraphDatabaseConfiguration.CUSTOM_ATTRIBUTE_NS, new String[0]);
        ArrayList all = new ArrayList(attributeIds.size());
        for (String attributeId : attributeIds) {
            AttributeSerializer<?> serializer;
            Class<?> clazz;
            int position = this.getAttributePosition(attributeId);
            RegisteredAttributeClass reg = new RegisteredAttributeClass(position, clazz = this.getAttributeClass(configuration, attributeId), serializer = this.getAttributeSerializer(configuration, attributeId));
            if (all.contains(reg)) {
                throw new IllegalArgumentException("Duplicate attribute registration: " + reg);
            }
            all.add(reg);
        }
        return all;
    }

    private int getAttributePosition(String attributeId) {
        Preconditions.checkArgument((boolean)attributeId.startsWith("attribute"), (String)"Invalid attribute definition: %s", (Object)attributeId);
        try {
            return Integer.parseInt(attributeId.substring("attribute".length()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected entry of the form [attributeX] where X is a number but given " + attributeId);
        }
    }

    private Class<?> getAttributeClass(Configuration configuration, String attributeId) {
        String classname = configuration.get(GraphDatabaseConfiguration.CUSTOM_ATTRIBUTE_CLASS, attributeId);
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find attribute class " + classname, e);
        }
    }

    private AttributeSerializer<?> getAttributeSerializer(Configuration configuration, String attributeId) {
        Preconditions.checkArgument((boolean)configuration.has(GraphDatabaseConfiguration.CUSTOM_SERIALIZER_CLASS, attributeId));
        String serializerName = configuration.get(GraphDatabaseConfiguration.CUSTOM_SERIALIZER_CLASS, attributeId);
        try {
            Class<?> serializerClass = Class.forName(serializerName);
            return (AttributeSerializer)serializerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find serializer class " + serializerName);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate serializer class " + serializerName, e);
        }
    }
}

