/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util.time;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Durations {
    private static final Map<String, TemporalUnit> unitNames = new HashMap<String, TemporalUnit>(){
        {
            for (ChronoUnit unit : Arrays.asList(ChronoUnit.NANOS, ChronoUnit.MICROS, ChronoUnit.MILLIS, ChronoUnit.SECONDS, ChronoUnit.MINUTES, ChronoUnit.HOURS, ChronoUnit.DAYS)) {
                this.put(Durations.abbreviate(unit), unit);
                String name = unit.toString().toLowerCase();
                this.put(name, unit);
                assert (name.endsWith("s"));
                this.put(name.substring(0, name.length() - 1), unit);
            }
            this.put("us", ChronoUnit.MICROS);
        }
    };

    public static Duration min(Duration x, Duration y) {
        return x.compareTo(y) <= 0 ? x : y;
    }

    public static String abbreviate(ChronoUnit unit) {
        switch (unit) {
            case NANOS: {
                return "ns";
            }
            case MICROS: {
                return "\u03bcs";
            }
            case MILLIS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "m";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new AssertionError((Object)("Unexpected time unit: " + unit));
    }

    public static TemporalUnit parse(String unitName) {
        TemporalUnit unit = unitNames.get(unitName.toLowerCase());
        Preconditions.checkNotNull((Object)unit, (String)"Unknown unit time: %s", (Object)unitName);
        return unit;
    }

    public static int compare(long length1, TimeUnit unit1, long length2, TimeUnit unit2) {
        long length2Adj = unit1.convert(length2, unit2);
        if (length1 < length2Adj) {
            return -1;
        }
        if (length2Adj < length1) {
            return 1;
        }
        return 0;
    }
}

