/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

public class ArrayUtil {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public static int growSpace(int oldCapacity, int minCapacity) {
        if (minCapacity < 0) {
            throw new IllegalArgumentException(String.format("required capacity %d is negative, likely caused by integer overflow", minCapacity));
        }
        if (minCapacity <= oldCapacity) {
            return oldCapacity;
        }
        if (minCapacity > 0x7FFFFFF7) {
            throw new IllegalArgumentException(String.format("required capacity %d is larger than MAX_ARRAY_SIZE [%d]", minCapacity, 0x7FFFFFF7));
        }
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        } else if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = 0x7FFFFFF7;
        }
        return newCapacity;
    }
}

