/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.keycolumnvalue.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeysQueriesGroup;
import org.janusgraph.diskstorage.keycolumnvalue.MultiKeysQueryGroups;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.cache.CachableStaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.cache.KCVSCache;
import org.janusgraph.diskstorage.util.CacheMetricsAction;
import org.janusgraph.graphdb.util.MultiSliceQueriesGroupingUtil;

public class ExpirationKCVSCache
extends KCVSCache {
    private static final int STATIC_ARRAY_BUFFER_SIZE = 64;
    private static final int KEY_QUERY_SIZE = 233;
    private static final int INVALIDATE_KEY_FRACTION_PENALTY = 1000;
    private static final int PENALTY_THRESHOLD = 5;
    private volatile CountDownLatch penaltyCountdown;
    private final Cache<KeySliceQuery, EntryList> cache;
    private final ConcurrentHashMap<StaticBuffer, Long> expiredKeys;
    private final long cacheTimeMS;
    private final long invalidationGracePeriodMS;
    private final CleanupThread cleanupThread;

    public ExpirationKCVSCache(KeyColumnValueStore store, String metricsName, long cacheTimeMS, long invalidationGracePeriodMS, long maximumByteSize) {
        super(store, metricsName);
        Preconditions.checkArgument((cacheTimeMS > 0L ? 1 : 0) != 0, (String)"Cache expiration must be positive: %s", (long)cacheTimeMS);
        Preconditions.checkArgument((System.currentTimeMillis() + 3153600000000L + cacheTimeMS > 0L ? 1 : 0) != 0, (String)"Cache expiration time too large, overflow may occur: %s", (long)cacheTimeMS);
        this.cacheTimeMS = cacheTimeMS;
        int concurrencyLevel = Runtime.getRuntime().availableProcessors();
        Preconditions.checkArgument((invalidationGracePeriodMS >= 0L ? 1 : 0) != 0, (String)"Invalid expiration grace period: %s", (long)invalidationGracePeriodMS);
        this.invalidationGracePeriodMS = invalidationGracePeriodMS;
        Caffeine cachebuilder = Caffeine.newBuilder().maximumWeight(maximumByteSize).initialCapacity(1000).expireAfterWrite(cacheTimeMS, TimeUnit.MILLISECONDS).weigher((keySliceQuery, entries) -> 337 + entries.getByteSize());
        this.cache = cachebuilder.build();
        this.expiredKeys = new ConcurrentHashMap(50, 0.75f, concurrencyLevel);
        this.penaltyCountdown = new CountDownLatch(5);
        this.cleanupThread = new CleanupThread();
        this.cleanupThread.start();
    }

    @Override
    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        this.incActionBy(1, CacheMetricsAction.RETRIEVAL, txh);
        if (this.isExpired(query)) {
            this.incActionBy(1, CacheMetricsAction.MISS, txh);
            return this.store.getSlice(query, this.unwrapTx(txh));
        }
        return (EntryList)this.cache.get((Object)query, key -> {
            this.incActionBy(1, CacheMetricsAction.MISS, txh);
            try {
                return this.store.getSlice(query, this.unwrapTx(txh));
            }
            catch (BackendException e) {
                if (e.getCause() instanceof JanusGraphException) {
                    throw (JanusGraphException)e.getCause();
                }
                throw new JanusGraphException(e);
            }
        });
    }

    @Override
    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        HashMap<StaticBuffer, EntryList> results = new HashMap<StaticBuffer, EntryList>(keys.size());
        this.incActionBy(keys.size(), CacheMetricsAction.RETRIEVAL, txh);
        Pair<List<StaticBuffer>, Map<StaticBuffer, KeySliceQuery>> misses = this.fillResultAndReturnMisses(results, query, keys);
        List remainingKeys = (List)misses.getKey();
        Map keySliceQueries = (Map)misses.getValue();
        if (!remainingKeys.isEmpty()) {
            this.incActionBy(remainingKeys.size(), CacheMetricsAction.MISS, txh);
            Map<StaticBuffer, EntryList> subresults = this.store.getSlice(remainingKeys, query, this.unwrapTx(txh));
            subresults.forEach((key, subresult) -> {
                KeySliceQuery ksqs = (KeySliceQuery)keySliceQueries.get(key);
                if (ksqs != null) {
                    this.cache.put((Object)ksqs, subresult);
                }
                results.put((StaticBuffer)key, (EntryList)subresult);
            });
        }
        return results;
    }

    @Override
    public Map<SliceQuery, Map<StaticBuffer, EntryList>> getMultiSlices(MultiKeysQueryGroups<StaticBuffer, SliceQuery> multiKeysQueryGroups, StoreTransaction txh) throws BackendException {
        HashMap<SliceQuery, Map<StaticBuffer, EntryList>> result = new HashMap<SliceQuery, Map<StaticBuffer, EntryList>>(multiKeysQueryGroups.getMultiQueryContext().getTotalAmountOfQueries());
        HashMap<SliceQuery, Object> remainingKeysPerQuery = new HashMap<SliceQuery, Object>(multiKeysQueryGroups.getMultiQueryContext().getTotalAmountOfQueries());
        List allQueryGroups = multiKeysQueryGroups.getQueryGroups();
        ArrayList updatedQueryGroups = new ArrayList();
        for (KeysQueriesGroup<StaticBuffer, SliceQuery> keysQueriesGroup : allQueryGroups) {
            List<StaticBuffer> currentKeys = keysQueriesGroup.getKeysGroup();
            List<SliceQuery> currentQueries = keysQueriesGroup.getQueries();
            if (currentKeys.isEmpty() || currentQueries.isEmpty()) continue;
            this.incActionBy(currentKeys.size() * currentQueries.size(), CacheMetricsAction.RETRIEVAL, txh);
            ArrayList<SliceQuery> remainingCurrentGroupQueries = new ArrayList<SliceQuery>(currentQueries.size());
            for (SliceQuery query : currentQueries) {
                Map currentQueryResult = result.computeIfAbsent(query, q -> new HashMap(currentKeys.size()));
                Pair<List<StaticBuffer>, Map<StaticBuffer, KeySliceQuery>> misses = this.fillResultAndReturnMisses(currentQueryResult, query, currentKeys);
                List remainingCurrentGroupKeys = (List)misses.getKey();
                remainingKeysPerQuery.put(query, misses.getValue());
                if (remainingCurrentGroupKeys.size() == currentKeys.size()) {
                    remainingCurrentGroupQueries.add(query);
                    continue;
                }
                if (remainingCurrentGroupKeys.isEmpty()) continue;
                updatedQueryGroups.add(Pair.of((Object)query, (Object)remainingCurrentGroupKeys));
            }
            if (remainingCurrentGroupQueries.size() == currentQueries.size()) continue;
            keysQueriesGroup.setQueries(remainingCurrentGroupQueries);
        }
        MultiSliceQueriesGroupingUtil.moveQueriesToNewLeafNode(updatedQueryGroups, multiKeysQueryGroups.getMultiQueryContext().getAllKeysArr(), multiKeysQueryGroups.getMultiQueryContext().getGroupingRootTreeNode(), allQueryGroups);
        allQueryGroups = this.filterEmptyGroups(allQueryGroups);
        multiKeysQueryGroups.setQueryGroups(allQueryGroups);
        if (!allQueryGroups.isEmpty()) {
            Map<SliceQuery, Map<StaticBuffer, EntryList>> subresults = this.store.getMultiSlices(multiKeysQueryGroups, this.unwrapTx(txh));
            subresults.forEach((sliceQuery, sliceQueryResultsPerKey) -> {
                Map currentSliceQueryResults;
                Map queryKeySliceQueriesPerVertexKey;
                if (!sliceQueryResultsPerKey.isEmpty()) {
                    this.incActionBy(sliceQueryResultsPerKey.size(), CacheMetricsAction.MISS, txh);
                }
                if ((queryKeySliceQueriesPerVertexKey = (Map)remainingKeysPerQuery.get(sliceQuery)) != null) {
                    sliceQueryResultsPerKey.forEach((key, keyResult) -> {
                        KeySliceQuery ksqs = (KeySliceQuery)queryKeySliceQueriesPerVertexKey.get(key);
                        if (ksqs != null) {
                            this.cache.put((Object)ksqs, keyResult);
                        }
                    });
                }
                if ((currentSliceQueryResults = (Map)result.get(sliceQuery)) == null) {
                    currentSliceQueryResults = sliceQueryResultsPerKey;
                    result.put((SliceQuery)sliceQuery, currentSliceQueryResults);
                } else {
                    currentSliceQueryResults.putAll(sliceQueryResultsPerKey);
                }
            });
        }
        return result;
    }

    private List<KeysQueriesGroup<StaticBuffer, SliceQuery>> filterEmptyGroups(List<KeysQueriesGroup<StaticBuffer, SliceQuery>> originalGroups) {
        ArrayList<KeysQueriesGroup<StaticBuffer, SliceQuery>> filteredGroups = new ArrayList<KeysQueriesGroup<StaticBuffer, SliceQuery>>(originalGroups.size());
        for (KeysQueriesGroup<StaticBuffer, SliceQuery> group : originalGroups) {
            if (group.getKeysGroup().isEmpty() || group.getQueries().isEmpty()) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    private Pair<List<StaticBuffer>, Map<StaticBuffer, KeySliceQuery>> fillResultAndReturnMisses(Map<StaticBuffer, EntryList> results, SliceQuery query, Collection<StaticBuffer> keys) {
        HashMap<StaticBuffer, KeySliceQuery> keySliceQueries = new HashMap<StaticBuffer, KeySliceQuery>(keys.size());
        ArrayList<StaticBuffer> remainingKeys = new ArrayList<StaticBuffer>(keys.size());
        for (StaticBuffer key : keys) {
            KeySliceQuery ksqs = new KeySliceQuery(key, query);
            if (this.isExpired(ksqs)) {
                remainingKeys.add(key);
                keySliceQueries.put(key, null);
                continue;
            }
            EntryList result = (EntryList)this.cache.getIfPresent((Object)ksqs);
            if (result == null) {
                remainingKeys.add(key);
                keySliceQueries.put(key, ksqs);
                continue;
            }
            results.put(key, result);
        }
        return Pair.of(remainingKeys, keySliceQueries);
    }

    @Override
    public void clearCache() {
        this.forceClearExpiredCache();
        this.cache.invalidateAll();
    }

    @Override
    public void invalidate(StaticBuffer key, List<CachableStaticBuffer> entries) {
        Preconditions.checkArgument((!this.hasValidateKeysOnly() || entries.isEmpty() ? 1 : 0) != 0);
        this.expiredKeys.put(key, this.getExpirationTime());
        if (Math.random() < 0.001) {
            this.penaltyCountdown.countDown();
        }
    }

    @Override
    public void forceClearExpiredCache() {
        this.clearExpiredCache(false);
    }

    private synchronized void clearExpiredCache(boolean withNewPenaltyCountdown) {
        HashMap<StaticBuffer, Long> expiredKeysCopy = new HashMap<StaticBuffer, Long>(this.expiredKeys.size());
        for (Map.Entry<StaticBuffer, Long> entry : this.expiredKeys.entrySet()) {
            if (this.isBeyondExpirationTime(entry.getValue())) {
                this.expiredKeys.remove(entry.getKey(), entry.getValue());
                continue;
            }
            if (this.getAge(entry.getValue()) < this.invalidationGracePeriodMS) continue;
            expiredKeysCopy.put(entry.getKey(), entry.getValue());
        }
        for (KeySliceQuery keySliceQuery : this.cache.asMap().keySet()) {
            if (!expiredKeysCopy.containsKey(keySliceQuery.getKey())) continue;
            this.cache.invalidate((Object)keySliceQuery);
        }
        if (withNewPenaltyCountdown) {
            this.penaltyCountdown = new CountDownLatch(5);
        }
        for (Map.Entry<StaticBuffer, Long> entry : expiredKeysCopy.entrySet()) {
            this.expiredKeys.remove(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void close() throws BackendException {
        this.cleanupThread.stopThread();
        super.close();
    }

    private boolean isExpired(KeySliceQuery query) {
        Long until = this.expiredKeys.get(query.getKey());
        if (until == null) {
            return false;
        }
        if (this.isBeyondExpirationTime(until)) {
            this.expiredKeys.remove(query.getKey(), until);
            return false;
        }
        this.penaltyCountdown.countDown();
        return true;
    }

    private long getExpirationTime() {
        return System.currentTimeMillis() + this.cacheTimeMS;
    }

    private boolean isBeyondExpirationTime(long until) {
        return until < System.currentTimeMillis();
    }

    private long getAge(long until) {
        long age = System.currentTimeMillis() - (until - this.cacheTimeMS);
        assert (age >= 0L);
        return age;
    }

    private class CleanupThread
    extends Thread {
        private boolean stop = false;

        public CleanupThread() {
            this.setDaemon(true);
            this.setName("ExpirationStoreCache-" + this.getId());
        }

        @Override
        public void run() {
            while (!this.stop) {
                try {
                    ExpirationKCVSCache.this.penaltyCountdown.await();
                }
                catch (InterruptedException e) {
                    if (this.stop) {
                        return;
                    }
                    throw new RuntimeException("Cleanup thread got interrupted", e);
                }
                ExpirationKCVSCache.this.clearExpiredCache(true);
            }
            return;
        }

        void stopThread() {
            this.stop = true;
            this.interrupt();
        }
    }
}

