/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;

public class MergedConfiguration
implements Configuration {
    private final Configuration first;
    private final Configuration second;

    public MergedConfiguration(Configuration first, Configuration second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public boolean has(ConfigOption option, boolean includeRoot, String ... umbrellaElements) {
        return this.first.has(option, includeRoot, umbrellaElements) || this.second.has(option, includeRoot, umbrellaElements);
    }

    @Override
    public <O> O get(ConfigOption<O> option, boolean includeRoot, String ... umbrellaElements) {
        if (this.first.has(option, includeRoot, umbrellaElements)) {
            return this.first.get(option, includeRoot, umbrellaElements);
        }
        if (this.second.has(option, includeRoot, umbrellaElements)) {
            return this.second.get(option, includeRoot, umbrellaElements);
        }
        return option.getDefaultValue();
    }

    @Override
    public Set<String> getContainedNamespaces(ConfigNamespace umbrella, String ... umbrellaElements) {
        Set<String> firstContainedNamespaces = this.first.getContainedNamespaces(umbrella, umbrellaElements);
        Set<String> secondContainedNamespaces = this.second.getContainedNamespaces(umbrella, umbrellaElements);
        HashSet<String> b = new HashSet<String>(firstContainedNamespaces.size() + secondContainedNamespaces.size());
        b.addAll(firstContainedNamespaces);
        b.addAll(secondContainedNamespaces);
        return Collections.unmodifiableSet(b);
    }

    @Override
    public Map<String, Object> getSubset(ConfigNamespace umbrella, String ... umbrellaElements) {
        Map<String, Object> fm = this.first.getSubset(umbrella, umbrellaElements);
        Map<String, Object> sm = this.second.getSubset(umbrella, umbrellaElements);
        HashMap<String, Object> b = new HashMap<String, Object>(fm.size() + sm.size());
        b.putAll(sm);
        b.putAll(fm);
        return Collections.unmodifiableMap(b);
    }

    @Override
    public Configuration restrictTo(String ... umbrellaElements) {
        return new MergedConfiguration(this.first.restrictTo(umbrellaElements), this.second.restrictTo(umbrellaElements));
    }
}

