/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.common;

import com.google.common.base.Preconditions;
import java.io.File;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.common.AbstractStoreManager;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.util.DirectoryUtil;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public abstract class LocalStoreManager
extends AbstractStoreManager {
    protected final File directory;

    public LocalStoreManager(Configuration storageConfig) throws BackendException {
        super(storageConfig);
        Preconditions.checkArgument((storageConfig.has(GraphDatabaseConfiguration.STORAGE_DIRECTORY, new String[0]) || storageConfig.has(GraphDatabaseConfiguration.STORAGE_ROOT, new String[0]) && storageConfig.has(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]) ? 1 : 0) != 0, (String)"Please supply configuration parameter \"%s\" or both \"%s\" and \"%s\".", (Object)GraphDatabaseConfiguration.STORAGE_DIRECTORY.toStringWithoutRoot(), (Object)GraphDatabaseConfiguration.STORAGE_ROOT.toStringWithoutRoot(), (Object)GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        if (storageConfig.has(GraphDatabaseConfiguration.STORAGE_DIRECTORY, new String[0])) {
            String storageDir = storageConfig.get(GraphDatabaseConfiguration.STORAGE_DIRECTORY, new String[0]);
            this.directory = DirectoryUtil.getOrCreateDataDirectory(storageDir);
        } else {
            String storageRoot = storageConfig.get(GraphDatabaseConfiguration.STORAGE_ROOT, new String[0]);
            String graphName = storageConfig.get(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]);
            this.directory = DirectoryUtil.getOrCreateDataDirectory(storageRoot, graphName);
        }
    }
}

