/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.schema;

import java.util.Date;
import java.util.UUID;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.schema.DefaultSchemaMaker;
import org.janusgraph.core.schema.EdgeLabelMaker;
import org.janusgraph.core.schema.PropertyKeyMaker;
import org.janusgraph.core.schema.SchemaManager;
import org.janusgraph.core.schema.VertexLabelMaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JanusGraphDefaultSchemaMaker
implements DefaultSchemaMaker {
    public static final DefaultSchemaMaker INSTANCE = new JanusGraphDefaultSchemaMaker();
    private static final Logger log = LoggerFactory.getLogger(JanusGraphDefaultSchemaMaker.class);
    private boolean loggingEnabled;

    private JanusGraphDefaultSchemaMaker() {
    }

    @Override
    public void enableLogging(Boolean enabled) {
        if (Boolean.TRUE.equals(enabled)) {
            this.loggingEnabled = true;
        }
    }

    @Override
    public Cardinality defaultPropertyCardinality(String key) {
        return Cardinality.SINGLE;
    }

    @Override
    public EdgeLabel makeEdgeLabel(EdgeLabelMaker factory) {
        this.logWarn("Edge label '{}' does not exist, will create now", factory.getName());
        return DefaultSchemaMaker.super.makeEdgeLabel(factory);
    }

    @Override
    public PropertyKey makePropertyKey(PropertyKeyMaker factory) {
        this.logWarn("Property key '{}' does not exist, will create now", factory.getName());
        return DefaultSchemaMaker.super.makePropertyKey(factory);
    }

    @Override
    public PropertyKey makePropertyKey(PropertyKeyMaker factory, Object value) {
        String name = factory.getName();
        this.logWarn("Property key '{}' does not exist, will create now", name);
        Class actualClass = this.determineClass(value);
        if (factory.cardinalityIsSet()) {
            return factory.dataType(actualClass).make();
        }
        return factory.cardinality(this.defaultPropertyCardinality(name)).dataType(actualClass).make();
    }

    @Override
    public VertexLabel makeVertexLabel(VertexLabelMaker factory) {
        this.logWarn("Vertex label '{}' does not exist, will create now", factory.getName());
        return DefaultSchemaMaker.super.makeVertexLabel(factory);
    }

    @Override
    public void makePropertyConstraintForVertex(VertexLabel vertexLabel, PropertyKey key, SchemaManager manager) {
        this.logWarn("Property key constraint does not exist for given vertex label '{}' and property key '{}', will create now", vertexLabel, key);
        DefaultSchemaMaker.super.makePropertyConstraintForVertex(vertexLabel, key, manager);
    }

    @Override
    public void makePropertyConstraintForEdge(EdgeLabel edgeLabel, PropertyKey key, SchemaManager manager) {
        this.logWarn("Property key constraint does not exist for given edge label '{}' and property key '{}', will create now", edgeLabel, key);
        DefaultSchemaMaker.super.makePropertyConstraintForEdge(edgeLabel, key, manager);
    }

    @Override
    public void makeConnectionConstraint(EdgeLabel edgeLabel, VertexLabel outVLabel, VertexLabel inVLabel, SchemaManager manager) {
        this.logWarn("Connection constraint does not exist for given edge label '{}', outgoing vertex label '{}' and incoming vertex label '{}', will create now", edgeLabel, outVLabel, inVLabel);
        DefaultSchemaMaker.super.makeConnectionConstraint(edgeLabel, outVLabel, inVLabel, manager);
    }

    @Override
    public boolean ignoreUndefinedQueryTypes() {
        return true;
    }

    private void logWarn(String message, Object ... objects) {
        if (this.loggingEnabled) {
            log.warn(message, objects);
        }
    }

    protected Class determineClass(Object value) {
        if (value instanceof String) {
            return String.class;
        }
        if (value instanceof Character) {
            return Character.class;
        }
        if (value instanceof Boolean) {
            return Boolean.class;
        }
        if (value instanceof Byte) {
            return Byte.class;
        }
        if (value instanceof Short) {
            return Short.class;
        }
        if (value instanceof Integer) {
            return Integer.class;
        }
        if (value instanceof Long) {
            return Long.class;
        }
        if (value instanceof Float) {
            return Float.class;
        }
        if (value instanceof Double) {
            return Double.class;
        }
        if (value instanceof Date) {
            return Date.class;
        }
        if (value instanceof Geoshape) {
            return Geoshape.class;
        }
        if (value instanceof UUID) {
            return UUID.class;
        }
        return Object.class;
    }
}

