/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types.indextype;

import com.google.common.collect.Iterables;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.graphdb.types.MixedIndexType;
import org.janusgraph.graphdb.types.ParameterIndexField;
import org.janusgraph.graphdb.types.SchemaSource;
import org.janusgraph.graphdb.types.TypeDefinitionCategory;
import org.janusgraph.graphdb.types.indextype.IndexTypeWrapper;

public class MixedIndexTypeWrapper
extends IndexTypeWrapper
implements MixedIndexType {
    public static final String NAME_PREFIX = "extindex";
    ParameterIndexField[] fields = null;

    public MixedIndexTypeWrapper(SchemaSource base) {
        super(base);
    }

    @Override
    public boolean isCompositeIndex() {
        return false;
    }

    @Override
    public boolean isMixedIndex() {
        return true;
    }

    @Override
    public ParameterIndexField[] getFieldKeys() {
        ParameterIndexField[] result = this.fields;
        if (result == null) {
            Iterable<SchemaSource.Entry> entries = this.base.getRelated(TypeDefinitionCategory.INDEX_FIELD, Direction.OUT);
            int numFields = Iterables.size(entries);
            result = new ParameterIndexField[numFields];
            int pos = 0;
            for (SchemaSource.Entry entry : entries) {
                assert (entry.getSchemaType() instanceof PropertyKey);
                assert (entry.getModifier() instanceof Parameter[]);
                result[pos++] = ParameterIndexField.of((PropertyKey)((Object)entry.getSchemaType()), (Parameter[])entry.getModifier());
            }
            this.fields = result;
        }
        assert (result != null);
        return result;
    }

    @Override
    public ParameterIndexField getField(PropertyKey key) {
        return (ParameterIndexField)super.getField(key);
    }

    @Override
    public void resetCache() {
        super.resetCache();
        this.fields = null;
    }

    @Override
    public String getStoreName() {
        return this.base.getDefinition().getValue(TypeDefinitionCategory.INDEXSTORE_NAME, String.class);
    }
}

