/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.graphdb.database.management.ModifierType;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.types.TypeDefinitionMap;

public enum TypeDefinitionCategory {
    INVISIBLE(Boolean.class),
    SORT_KEY(long[].class),
    SORT_ORDER(Order.class),
    SIGNATURE(long[].class),
    MULTIPLICITY(Multiplicity.class),
    DATATYPE(Class.class),
    UNIDIRECTIONAL(Direction.class),
    STATUS(SchemaStatus.class),
    ELEMENT_CATEGORY(ElementCategory.class),
    INDEX_CARDINALITY(Cardinality.class),
    INTERNAL_INDEX(Boolean.class),
    BACKING_INDEX(String.class),
    INDEXSTORE_NAME(String.class),
    CONSISTENCY_LEVEL(ConsistencyModifier.class),
    TTL(Integer.class),
    PARTITIONED(Boolean.class),
    STATIC(Boolean.class),
    RELATIONTYPE_INDEX,
    TYPE_MODIFIER,
    INDEX_FIELD(RelationCategory.EDGE, Parameter[].class),
    INDEX_SCHEMA_CONSTRAINT,
    PROPERTY_KEY_EDGE,
    CONNECTION_EDGE(RelationCategory.EDGE, String.class),
    UPDATE_CONNECTION_EDGE;

    public static final Set<TypeDefinitionCategory> PROPERTYKEY_DEFINITION_CATEGORIES;
    public static final Set<TypeDefinitionCategory> EDGELABEL_DEFINITION_CATEGORIES;
    public static final Set<TypeDefinitionCategory> INDEX_DEFINITION_CATEGORIES;
    public static final Set<TypeDefinitionCategory> VERTEXLABEL_DEFINITION_CATEGORIES;
    public static final Set<TypeDefinitionCategory> TYPE_MODIFIER_DEFINITION_CATEGORIES;
    private final RelationCategory relationCategory;
    private final Class dataType;

    private TypeDefinitionCategory() {
        this(RelationCategory.EDGE, null);
    }

    private TypeDefinitionCategory(Class<?> dataType) {
        this(RelationCategory.PROPERTY, dataType);
    }

    private TypeDefinitionCategory(RelationCategory relCat, Class<?> dataType) {
        Preconditions.checkArgument((relCat != null && relCat.isProper() ? 1 : 0) != 0);
        Preconditions.checkArgument((relCat == RelationCategory.EDGE || dataType != null ? 1 : 0) != 0);
        this.relationCategory = relCat;
        this.dataType = dataType;
    }

    public boolean hasDataType() {
        return this.dataType != null;
    }

    public Class<?> getDataType() {
        Preconditions.checkState((boolean)this.hasDataType());
        return this.dataType;
    }

    public boolean isProperty() {
        return this.relationCategory == RelationCategory.PROPERTY;
    }

    public boolean isEdge() {
        return this.relationCategory == RelationCategory.EDGE;
    }

    public boolean verifyAttribute(Object attribute) {
        Preconditions.checkNotNull((Object)this.dataType);
        return attribute != null && this.dataType.equals(attribute.getClass());
    }

    public Object defaultValue(TypeDefinitionMap map) {
        switch (this) {
            case SORT_ORDER: {
                return Order.ASC;
            }
            case STATUS: {
                return SchemaStatus.ENABLED;
            }
        }
        return null;
    }

    static {
        PROPERTYKEY_DEFINITION_CATEGORIES = ImmutableSet.of((Object)((Object)STATUS), (Object)((Object)INVISIBLE), (Object)((Object)SORT_KEY), (Object)((Object)SORT_ORDER), (Object)((Object)SIGNATURE), (Object)((Object)MULTIPLICITY), (Object[])new TypeDefinitionCategory[]{DATATYPE});
        EDGELABEL_DEFINITION_CATEGORIES = ImmutableSet.of((Object)((Object)STATUS), (Object)((Object)INVISIBLE), (Object)((Object)SORT_KEY), (Object)((Object)SORT_ORDER), (Object)((Object)SIGNATURE), (Object)((Object)MULTIPLICITY), (Object[])new TypeDefinitionCategory[]{UNIDIRECTIONAL});
        INDEX_DEFINITION_CATEGORIES = ImmutableSet.of((Object)((Object)STATUS), (Object)((Object)ELEMENT_CATEGORY), (Object)((Object)INDEX_CARDINALITY), (Object)((Object)INTERNAL_INDEX), (Object)((Object)BACKING_INDEX), (Object)((Object)INDEXSTORE_NAME), (Object[])new TypeDefinitionCategory[0]);
        VERTEXLABEL_DEFINITION_CATEGORIES = ImmutableSet.of((Object)((Object)PARTITIONED), (Object)((Object)STATIC));
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ModifierType type : ModifierType.values()) {
            builder.add((Object)type.getCategory());
        }
        TYPE_MODIFIER_DEFINITION_CATEGORIES = builder.build();
    }
}

