/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.BranchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.OptionalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.TraversalFilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedVertex;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.olap.computer.FulgoraElementTraversal;
import org.janusgraph.graphdb.tinkerpop.JanusGraphBlueprintsGraph;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphVertexStep;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class JanusGraphTraversalUtil {
    private static final List<Class<? extends TraversalParent>> MULTIQUERY_COMPATIBLE_STEPS = Arrays.asList(BranchStep.class, OptionalStep.class, RepeatStep.class, TraversalFilterStep.class);

    public static JanusGraphVertex getJanusGraphVertex(Element v) {
        while (v instanceof WrappedVertex) {
            v = (Element)((WrappedVertex)v).getBaseVertex();
        }
        if (v instanceof JanusGraphVertex) {
            return (JanusGraphVertex)v;
        }
        throw new IllegalArgumentException("Expected traverser of JanusGraph vertex but found: " + v);
    }

    public static JanusGraphVertex getJanusGraphVertex(Traverser<? extends Element> traverser) {
        return JanusGraphTraversalUtil.getJanusGraphVertex((Element)traverser.get());
    }

    public static boolean isEdgeReturnStep(JanusGraphVertexStep vertexStep) {
        return Edge.class.isAssignableFrom(vertexStep.getReturnClass());
    }

    public static boolean isVertexReturnStep(JanusGraphVertexStep vertexStep) {
        return Vertex.class.isAssignableFrom(vertexStep.getReturnClass());
    }

    public static Step getNextNonIdentityStep(Step start) {
        Step currentStep = start.getNextStep();
        while (currentStep instanceof IdentityStep) {
            currentStep = currentStep.getNextStep();
        }
        return currentStep;
    }

    public static JanusGraphTransaction getTx(Traversal.Admin<?, ?> traversal) {
        JanusGraphTransaction tx;
        Optional optGraph = TraversalHelper.getRootTraversal((Traversal.Admin)traversal.asAdmin()).getGraph();
        if (traversal instanceof FulgoraElementTraversal) {
            tx = (JanusGraphTransaction)optGraph.get();
        } else {
            if (!optGraph.isPresent()) {
                throw new IllegalArgumentException("Traversal is not bound to a graph: " + traversal);
            }
            Graph graph = (Graph)optGraph.get();
            if (graph instanceof JanusGraphTransaction) {
                tx = (JanusGraphTransaction)graph;
            } else if (graph instanceof JanusGraphBlueprintsGraph) {
                tx = ((JanusGraphBlueprintsGraph)graph).getCurrentThreadTx();
            } else {
                throw new IllegalArgumentException("Traversal is not bound to a JanusGraph Graph, but: " + graph);
            }
        }
        if (tx == null) {
            throw new IllegalArgumentException("Not a valid start step for a JanusGraph traversal: " + traversal);
        }
        if (tx.isOpen()) {
            return tx;
        }
        return ((StandardJanusGraphTx)tx).getNextTx();
    }

    public static List<Step> getMultiQueryCompatibleSteps(Traversal.Admin<?, ?> traversal) {
        HashSet multiQueryCompatibleSteps = new HashSet();
        for (Step step : traversal.getSteps()) {
            RepeatStep repeatStep;
            List repeatEndSteps;
            if (!JanusGraphTraversalUtil.isMultiQueryCompatibleStep(step)) continue;
            Step parentStep = step;
            ((TraversalParent)parentStep).getGlobalChildren().forEach(childTraversal -> JanusGraphTraversalUtil.getMultiQueryCompatibleStepsFromChildTraversal(childTraversal, parentStep, multiQueryCompatibleSteps));
            ((TraversalParent)parentStep).getLocalChildren().forEach(childTraversal -> JanusGraphTraversalUtil.getMultiQueryCompatibleStepsFromChildTraversal(childTraversal, parentStep, multiQueryCompatibleSteps));
            if (!(parentStep instanceof RepeatStep) || !multiQueryCompatibleSteps.contains(parentStep) || (repeatEndSteps = TraversalHelper.getStepsOfClass(RepeatStep.RepeatEndStep.class, (Traversal.Admin)(repeatStep = (RepeatStep)parentStep).getRepeatTraversal())).size() != 1) continue;
            multiQueryCompatibleSteps.remove(parentStep);
            multiQueryCompatibleSteps.add(repeatEndSteps.get(0));
        }
        return Lists.newArrayList(multiQueryCompatibleSteps);
    }

    private static void getMultiQueryCompatibleStepsFromChildTraversal(Traversal.Admin<?, ?> childTraversal, Step parentStep, Set<Step> multiQueryCompatibleSteps) {
        Step firstStep = childTraversal.getStartStep();
        while (firstStep instanceof StartStep || firstStep instanceof SideEffectStep) {
            firstStep = firstStep.getNextStep();
        }
        if (firstStep.getClass().isAssignableFrom(VertexStep.class)) {
            multiQueryCompatibleSteps.add(parentStep);
        }
    }

    public static boolean isMultiQueryCompatibleStep(Step<?, ?> currentStep) {
        return MULTIQUERY_COMPATIBLE_STEPS.stream().filter(stepClass -> stepClass.isInstance(currentStep)).findFirst().isPresent();
    }
}

