/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database.serialize.attribute;

import java.lang.reflect.Array;
import org.janusgraph.core.attribute.AttributeSerializer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.WriteBuffer;
import org.janusgraph.graphdb.database.serialize.attribute.ArraySerializer;

public class DoubleArraySerializer
extends ArraySerializer
implements AttributeSerializer<double[]> {
    @Override
    public double[] convert(Object value) {
        return (double[])this.convertInternal(value, Double.TYPE, Double.class);
    }

    @Override
    protected Object getArray(int length) {
        return new double[length];
    }

    @Override
    protected void setArray(Object array, int pos, Object value) {
        Array.setDouble(array, pos, (Double)value);
    }

    @Override
    public double[] read(ScanBuffer buffer) {
        int length = this.getLength(buffer);
        if (length < 0) {
            return null;
        }
        return buffer.getDoubles(length);
    }

    @Override
    public void write(WriteBuffer buffer, double[] attribute) {
        this.writeLength(buffer, attribute);
        if (attribute != null) {
            for (double anAttribute : attribute) {
                buffer.putDouble(anAttribute);
            }
        }
    }
}

