/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.database;

import com.carrotsearch.hppc.LongArrayList;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.diskstorage.Backend;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.indexing.IndexTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRangeQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.cache.KCVSCache;
import org.janusgraph.diskstorage.log.Log;
import org.janusgraph.diskstorage.log.Message;
import org.janusgraph.diskstorage.log.ReadMarker;
import org.janusgraph.diskstorage.log.kcvs.ExternalPersistor;
import org.janusgraph.diskstorage.log.kcvs.KCVSLog;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.EdgeSerializer;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.database.RelationQueryCache;
import org.janusgraph.graphdb.database.cache.SchemaCache;
import org.janusgraph.graphdb.database.idassigner.VertexIDAssigner;
import org.janusgraph.graphdb.database.idhandling.IDHandler;
import org.janusgraph.graphdb.database.log.LogTxStatus;
import org.janusgraph.graphdb.database.log.TransactionLogHeader;
import org.janusgraph.graphdb.database.management.ManagementLogger;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.database.serialize.Serializer;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.internal.InternalVertexLabel;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.relations.EdgeDirection;
import org.janusgraph.graphdb.tinkerpop.JanusGraphBlueprintsGraph;
import org.janusgraph.graphdb.tinkerpop.JanusGraphFeatures;
import org.janusgraph.graphdb.tinkerpop.optimize.AdjacentVertexFilterOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.AdjacentVertexHasIdOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.AdjacentVertexIsOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphIoRegistrationStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphLocalQueryOptimizerStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphStepStrategy;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.transaction.StandardTransactionBuilder;
import org.janusgraph.graphdb.transaction.TransactionConfiguration;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.MixedIndexType;
import org.janusgraph.graphdb.types.system.BaseKey;
import org.janusgraph.graphdb.types.system.BaseRelationType;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.graphdb.util.ExceptionFactory;
import org.janusgraph.util.system.IOUtils;
import org.janusgraph.util.system.TXUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardJanusGraph
extends JanusGraphBlueprintsGraph {
    private static final Logger log = LoggerFactory.getLogger(StandardJanusGraph.class);
    private final GraphDatabaseConfiguration config;
    private final Backend backend;
    private final IDManager idManager;
    private final VertexIDAssigner idAssigner;
    private final TimestampProvider times;
    protected final IndexSerializer indexSerializer;
    protected final EdgeSerializer edgeSerializer;
    protected final Serializer serializer;
    public final SliceQuery vertexExistenceQuery;
    private final RelationQueryCache queryCache;
    private final SchemaCache schemaCache;
    private final ManagementLogger managementLogger;
    private volatile ShutdownThread shutdownHook;
    private volatile boolean isOpen;
    private final AtomicLong txCounter;
    private final Set<StandardJanusGraphTx> openTransactions;
    private final String name;
    private final SchemaCache.StoreRetrieval typeCacheRetrieval = new SchemaCache.StoreRetrieval(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long retrieveSchemaByName(String typeName) {
            Long l;
            Configuration customTxOptions = StandardJanusGraph.this.backend.getStoreFeatures().getKeyConsistentTxConfig();
            StandardJanusGraphTx consistentTx = null;
            try {
                consistentTx = StandardJanusGraph.this.newTransaction(new StandardTransactionBuilder(StandardJanusGraph.this.getConfiguration(), StandardJanusGraph.this, customTxOptions).groupName("org.janusgraph.sys.schema"));
                consistentTx.getTxHandle().disableCache();
                JanusGraphVertex v = (JanusGraphVertex)Iterables.getOnlyElement(QueryUtil.getVertices(consistentTx, BaseKey.SchemaName, (Object)typeName), null);
                l = v != null ? Long.valueOf(v.longId()) : null;
            }
            catch (Throwable throwable) {
                TXUtils.rollbackQuietly(consistentTx);
                throw throwable;
            }
            TXUtils.rollbackQuietly(consistentTx);
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public EntryList retrieveSchemaRelations(long schemaId, BaseRelationType type, Direction dir) {
            EntryList entryList;
            SliceQuery query = StandardJanusGraph.this.queryCache.getQuery(type, dir);
            Configuration customTxOptions = StandardJanusGraph.this.backend.getStoreFeatures().getKeyConsistentTxConfig();
            StandardJanusGraphTx consistentTx = null;
            try {
                consistentTx = StandardJanusGraph.this.newTransaction(new StandardTransactionBuilder(StandardJanusGraph.this.getConfiguration(), StandardJanusGraph.this, customTxOptions).groupName("org.janusgraph.sys.schema"));
                consistentTx.getTxHandle().disableCache();
                entryList = StandardJanusGraph.this.edgeQuery(schemaId, query, consistentTx.getTxHandle());
            }
            catch (Throwable throwable) {
                TXUtils.rollbackQuietly(consistentTx);
                throw throwable;
            }
            TXUtils.rollbackQuietly(consistentTx);
            return entryList;
        }
    };
    private static final Predicate<InternalRelation> SCHEMA_FILTER;
    private static final Predicate<InternalRelation> NO_SCHEMA_FILTER;
    private static final Predicate<InternalRelation> NO_FILTER;

    public StandardJanusGraph(GraphDatabaseConfiguration configuration) {
        this.config = configuration;
        this.backend = configuration.getBackend();
        this.name = configuration.getGraphName();
        this.idAssigner = this.config.getIDAssigner(this.backend);
        this.idManager = this.idAssigner.getIDManager();
        this.serializer = this.config.getSerializer();
        StoreFeatures storeFeatures = this.backend.getStoreFeatures();
        this.indexSerializer = new IndexSerializer(configuration.getConfiguration(), this.serializer, this.backend.getIndexInformation(), storeFeatures.isDistributed() && storeFeatures.isKeyOrdered());
        this.edgeSerializer = new EdgeSerializer(this.serializer);
        this.vertexExistenceQuery = this.edgeSerializer.getQuery(BaseKey.VertexExists, Direction.OUT, new EdgeSerializer.TypedInterval[0]).setLimit(1);
        this.queryCache = new RelationQueryCache(this.edgeSerializer);
        this.schemaCache = configuration.getTypeCache(this.typeCacheRetrieval);
        this.times = configuration.getTimestampProvider();
        this.isOpen = true;
        this.txCounter = new AtomicLong(0L);
        this.openTransactions = Collections.newSetFromMap(new ConcurrentHashMap(100, 0.75f, 1));
        String uniqueInstanceId = configuration.getUniqueGraphId();
        ModifiableConfiguration globalConfig = this.getGlobalSystemConfig(this.backend);
        boolean instanceExists = globalConfig.has(GraphDatabaseConfiguration.REGISTRATION_TIME, uniqueInstanceId);
        boolean replaceExistingInstance = configuration.getConfiguration().get(GraphDatabaseConfiguration.REPLACE_INSTANCE_IF_EXISTS, new String[0]);
        if (instanceExists && !replaceExistingInstance) {
            throw new JanusGraphException(String.format("A JanusGraph graph with the same instance id [%s] is already open. Might required forced shutdown.", uniqueInstanceId));
        }
        if (instanceExists && replaceExistingInstance) {
            log.debug(String.format("Instance [%s] already exists. Opening the graph per " + GraphDatabaseConfiguration.REPLACE_INSTANCE_IF_EXISTS.getName() + " configuration.", uniqueInstanceId));
        }
        globalConfig.set(GraphDatabaseConfiguration.REGISTRATION_TIME, this.times.getTime(), uniqueInstanceId);
        Log managementLog = this.backend.getSystemMgmtLog();
        this.managementLogger = new ManagementLogger(this, managementLog, this.schemaCache, this.times);
        managementLog.registerReader(ReadMarker.fromNow(), this.managementLogger);
        this.shutdownHook = new ShutdownThread(this);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        log.debug("Installed shutdown hook {}", (Object)this.shutdownHook, (Object)new Throwable("Hook creation trace"));
    }

    public String getGraphName() {
        return this.name;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen();
    }

    @Override
    public synchronized void close() throws JanusGraphException {
        try {
            this.closeInternal();
        }
        finally {
            this.removeHook();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeInternal() {
        if (!this.isOpen) {
            return;
        }
        HashMap<StandardJanusGraphTx, RuntimeException> txCloseExceptions = new HashMap<StandardJanusGraphTx, RuntimeException>();
        try {
            String uniqueId = null;
            try {
                uniqueId = this.config.getUniqueGraphId();
                ModifiableConfiguration globalConfig = this.getGlobalSystemConfig(this.backend);
                globalConfig.remove(GraphDatabaseConfiguration.REGISTRATION_TIME, uniqueId);
            }
            catch (Exception e) {
                log.warn("Unable to remove graph instance uniqueid {}", (Object)uniqueId, (Object)e);
            }
            for (StandardJanusGraphTx otx : this.openTransactions) {
                try {
                    otx.rollback();
                    otx.close();
                }
                catch (RuntimeException e) {
                    log.warn("Unable to close transaction {}", (Object)otx, (Object)e);
                    txCloseExceptions.put(otx, e);
                }
            }
            super.close();
            IOUtils.closeQuietly(this.idAssigner);
            IOUtils.closeQuietly(this.backend);
            IOUtils.closeQuietly(this.queryCache);
            IOUtils.closeQuietly(this.serializer);
        }
        finally {
            this.isOpen = false;
        }
        if (1 == txCloseExceptions.size()) {
            throw new IllegalStateException("Unable to close transaction", (Throwable)Iterables.getOnlyElement(txCloseExceptions.values()));
        }
        if (1 < txCloseExceptions.size()) {
            throw new IllegalStateException(String.format("Unable to close %s transactions (see warnings in log output for details)", txCloseExceptions.size()));
        }
    }

    private synchronized void removeHook() {
        if (null == this.shutdownHook) {
            return;
        }
        ShutdownThread tmp = this.shutdownHook;
        this.shutdownHook = null;
        try {
            Runtime.getRuntime().removeShutdownHook(tmp);
            log.debug("Removed shutdown hook {}", (Object)tmp);
        }
        catch (IllegalStateException e) {
            log.warn("Failed to remove shutdown hook", (Throwable)e);
        }
    }

    public Graph.Features features() {
        return JanusGraphFeatures.getFeatures(this, this.backend.getStoreFeatures());
    }

    public IndexSerializer getIndexSerializer() {
        return this.indexSerializer;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public IDManager getIDManager() {
        return this.idManager;
    }

    public EdgeSerializer getEdgeSerializer() {
        return this.edgeSerializer;
    }

    public Serializer getDataSerializer() {
        return this.serializer;
    }

    public SchemaCache getSchemaCache() {
        return this.schemaCache;
    }

    public GraphDatabaseConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public JanusGraphManagement openManagement() {
        return new ManagementSystem(this, this.backend.getGlobalSystemConfig(), this.backend.getSystemMgmtLog(), this.managementLogger, this.schemaCache);
    }

    public Set<? extends JanusGraphTransaction> getOpenTransactions() {
        return Sets.newHashSet(this.openTransactions);
    }

    @Override
    public JanusGraphTransaction newTransaction() {
        return this.buildTransaction().start();
    }

    @Override
    public StandardTransactionBuilder buildTransaction() {
        return new StandardTransactionBuilder(this.getConfiguration(), this);
    }

    @Override
    public JanusGraphTransaction newThreadBoundTransaction() {
        return this.buildTransaction().threadBound().start();
    }

    public StandardJanusGraphTx newTransaction(TransactionConfiguration configuration) {
        if (!this.isOpen) {
            ExceptionFactory.graphShutdown();
        }
        try {
            StandardJanusGraphTx tx = new StandardJanusGraphTx(this, configuration);
            tx.setBackendTransaction(this.openBackendTransaction(tx));
            this.openTransactions.add(tx);
            return tx;
        }
        catch (BackendException e) {
            throw new JanusGraphException("Could not start new transaction", e);
        }
    }

    private BackendTransaction openBackendTransaction(StandardJanusGraphTx tx) throws BackendException {
        IndexSerializer.IndexInfoRetriever retriever = this.indexSerializer.getIndexInfoRetriever(tx);
        return this.backend.beginTransaction(tx.getConfiguration(), retriever);
    }

    public void closeTransaction(StandardJanusGraphTx tx) {
        this.openTransactions.remove(tx);
    }

    public RecordIterator<Long> getVertexIDs(BackendTransaction tx) {
        Preconditions.checkArgument((this.backend.getStoreFeatures().hasOrderedScan() || this.backend.getStoreFeatures().hasUnorderedScan() ? 1 : 0) != 0, (Object)"The configured storage backend does not support global graph operations - use Faunus instead");
        final KeyIterator keyIterator = this.backend.getStoreFeatures().hasUnorderedScan() ? tx.edgeStoreKeys(this.vertexExistenceQuery) : tx.edgeStoreKeys(new KeyRangeQuery(IDHandler.MIN_KEY, IDHandler.MAX_KEY, this.vertexExistenceQuery));
        return new RecordIterator<Long>(){

            @Override
            public boolean hasNext() {
                return keyIterator.hasNext();
            }

            @Override
            public Long next() {
                return StandardJanusGraph.this.idManager.getKeyID((StaticBuffer)keyIterator.next());
            }

            @Override
            public void close() throws IOException {
                keyIterator.close();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal not supported");
            }
        };
    }

    public EntryList edgeQuery(long vid, SliceQuery query, BackendTransaction tx) {
        Preconditions.checkArgument((vid > 0L ? 1 : 0) != 0);
        return tx.edgeStoreQuery(new KeySliceQuery(this.idManager.getKey(vid), query));
    }

    public List<EntryList> edgeMultiQuery(LongArrayList vertexIdsAsLongs, SliceQuery query, BackendTransaction tx) {
        Preconditions.checkArgument((vertexIdsAsLongs != null && !vertexIdsAsLongs.isEmpty() ? 1 : 0) != 0);
        ArrayList<StaticBuffer> vertexIds = new ArrayList<StaticBuffer>(vertexIdsAsLongs.size());
        for (int i = 0; i < vertexIdsAsLongs.size(); ++i) {
            Preconditions.checkArgument((vertexIdsAsLongs.get(i) > 0L ? 1 : 0) != 0);
            vertexIds.add(this.idManager.getKey(vertexIdsAsLongs.get(i)));
        }
        Map<StaticBuffer, EntryList> result = tx.edgeStoreMultiQuery(vertexIds, query);
        ArrayList<EntryList> resultList = new ArrayList<EntryList>(result.size());
        for (StaticBuffer v : vertexIds) {
            resultList.add(result.get(v));
        }
        return resultList;
    }

    private ModifiableConfiguration getGlobalSystemConfig(Backend backend) {
        return new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, backend.getGlobalSystemConfig(), BasicConfiguration.Restriction.GLOBAL);
    }

    public void assignID(InternalRelation relation) {
        this.idAssigner.assignID(relation);
    }

    public void assignID(InternalVertex vertex, VertexLabel label) {
        this.idAssigner.assignID(vertex, label);
    }

    public static boolean acquireLock(InternalRelation relation, int pos, boolean acquireLocksConfig) {
        InternalRelationType type = (InternalRelationType)relation.getType();
        return acquireLocksConfig && type.getConsistencyModifier() == ConsistencyModifier.LOCK && (type.multiplicity().isUnique(EdgeDirection.fromPosition(pos)) || pos == 0 && type.multiplicity() == Multiplicity.SIMPLE);
    }

    public static boolean acquireLock(CompositeIndexType index, boolean acquireLocksConfig) {
        return acquireLocksConfig && index.getConsistencyModifier() == ConsistencyModifier.LOCK && index.getCardinality() != Cardinality.LIST;
    }

    public static int getTTL(InternalRelation rel) {
        assert (rel.isNew());
        InternalRelationType baseType = (InternalRelationType)rel.getType();
        assert (baseType.getBaseType() == null);
        int ttl = 0;
        Integer ettl = baseType.getTTL();
        if (ettl > 0) {
            ttl = ettl;
        }
        for (int i = 0; i < rel.getArity(); ++i) {
            int vttl = StandardJanusGraph.getTTL(rel.getVertex(i));
            if (vttl <= 0 || vttl >= ttl && ttl > 0) continue;
            ttl = vttl;
        }
        return ttl;
    }

    public static int getTTL(InternalVertex v) {
        assert (v.hasId());
        if (IDManager.VertexIDType.UnmodifiableVertex.is(v.longId())) {
            assert (v.isNew()) : "Should not be able to add relations to existing static vertices: " + v;
            return ((InternalVertexLabel)v.vertexLabel()).getTTL();
        }
        return 0;
    }

    public ModificationSummary prepareCommit(Collection<InternalRelation> addedRelations, Collection<InternalRelation> deletedRelations, Predicate<InternalRelation> filter, BackendTransaction mutator, StandardJanusGraphTx tx, boolean acquireLocks) throws BackendException {
        Entry entry;
        InternalVertex vertex;
        int pos;
        ArrayListMultimap mutations = ArrayListMultimap.create();
        ArrayListMultimap mutatedProperties = ArrayListMultimap.create();
        ArrayList indexUpdates = Lists.newArrayList();
        for (InternalRelation del : Iterables.filter(deletedRelations, filter)) {
            Preconditions.checkArgument((boolean)del.isRemoved());
            for (pos = 0; pos < del.getLen(); ++pos) {
                vertex = del.getVertex(pos);
                if (pos == 0 || !del.isLoop()) {
                    if (del.isProperty()) {
                        mutatedProperties.put((Object)vertex, (Object)del);
                    }
                    mutations.put((Object)vertex.longId(), (Object)del);
                }
                if (!StandardJanusGraph.acquireLock(del, pos, acquireLocks)) continue;
                entry = this.edgeSerializer.writeRelation(del, pos, tx);
                mutator.acquireEdgeLock(this.idManager.getKey(vertex.longId()), entry);
            }
            indexUpdates.addAll(this.indexSerializer.getIndexUpdates(del));
        }
        for (InternalRelation add : Iterables.filter(addedRelations, filter)) {
            Preconditions.checkArgument((boolean)add.isNew());
            for (pos = 0; pos < add.getLen(); ++pos) {
                vertex = add.getVertex(pos);
                if (pos == 0 || !add.isLoop()) {
                    if (add.isProperty()) {
                        mutatedProperties.put((Object)vertex, (Object)add);
                    }
                    mutations.put((Object)vertex.longId(), (Object)add);
                }
                if (vertex.isNew() || !StandardJanusGraph.acquireLock(add, pos, acquireLocks)) continue;
                entry = this.edgeSerializer.writeRelation(add, pos, tx);
                mutator.acquireEdgeLock(this.idManager.getKey(vertex.longId()), entry.getColumn());
            }
            indexUpdates.addAll(this.indexSerializer.getIndexUpdates(add));
        }
        for (InternalVertex v : mutatedProperties.keySet()) {
            indexUpdates.addAll(this.indexSerializer.getIndexUpdates(v, mutatedProperties.get((Object)v)));
        }
        for (IndexSerializer.IndexUpdate update : indexUpdates) {
            CompositeIndexType iIndex;
            if (!update.isCompositeIndex() || !update.isDeletion() || !StandardJanusGraph.acquireLock(iIndex = (CompositeIndexType)update.getIndex(), acquireLocks)) continue;
            mutator.acquireIndexLock((StaticBuffer)update.getKey(), (Entry)update.getEntry());
        }
        for (IndexSerializer.IndexUpdate update : indexUpdates) {
            CompositeIndexType iIndex;
            if (!update.isCompositeIndex() || !update.isAddition() || !StandardJanusGraph.acquireLock(iIndex = (CompositeIndexType)update.getIndex(), acquireLocks)) continue;
            mutator.acquireIndexLock((StaticBuffer)update.getKey(), ((Entry)update.getEntry()).getColumn());
        }
        for (Long vertexId : mutations.keySet()) {
            Preconditions.checkArgument((vertexId > 0L ? 1 : 0) != 0, (String)"Vertex has no id: %s", (Object[])new Object[]{vertexId});
            List edges = mutations.get((Object)vertexId);
            ArrayList<Entry> additions = new ArrayList<Entry>(edges.size());
            ArrayList<Entry> deletions = new ArrayList<Entry>(Math.max(10, edges.size() / 10));
            for (InternalRelation edge : edges) {
                InternalRelationType baseType = (InternalRelationType)edge.getType();
                assert (baseType.getBaseType() == null);
                for (InternalRelationType type : baseType.getRelationIndexes()) {
                    if (type.getStatus() == SchemaStatus.DISABLED) continue;
                    for (int pos2 = 0; pos2 < edge.getArity(); ++pos2) {
                        if (!type.isUnidirected(Direction.BOTH) && !type.isUnidirected(EdgeDirection.fromPosition(pos2)) || edge.getVertex(pos2).longId() != vertexId.longValue()) continue;
                        StaticArrayEntry entry2 = this.edgeSerializer.writeRelation(edge, type, pos2, tx);
                        if (edge.isRemoved()) {
                            deletions.add(entry2);
                            continue;
                        }
                        Preconditions.checkArgument((boolean)edge.isNew());
                        int ttl = StandardJanusGraph.getTTL(edge);
                        if (ttl > 0) {
                            entry2.setMetaData(EntryMetaData.TTL, ttl);
                        }
                        additions.add(entry2);
                    }
                }
            }
            StaticBuffer vertexKey = this.idManager.getKey(vertexId);
            mutator.mutateEdges(vertexKey, additions, deletions);
        }
        boolean has2iMods = false;
        for (IndexSerializer.IndexUpdate indexUpdate : indexUpdates) {
            IndexSerializer.IndexUpdate update;
            assert (indexUpdate.isAddition() || indexUpdate.isDeletion());
            if (indexUpdate.isCompositeIndex()) {
                update = indexUpdate;
                if (update.isAddition()) {
                    mutator.mutateIndex((StaticBuffer)update.getKey(), Lists.newArrayList((Object[])new Entry[]{(Entry)update.getEntry()}), KCVSCache.NO_DELETIONS);
                    continue;
                }
                mutator.mutateIndex((StaticBuffer)update.getKey(), KeyColumnValueStore.NO_ADDITIONS, Lists.newArrayList((Object[])new Entry[]{(Entry)update.getEntry()}));
                continue;
            }
            update = indexUpdate;
            has2iMods = true;
            IndexTransaction itx = mutator.getIndexTransaction(update.getIndex().getBackingIndexName());
            String indexStore = ((MixedIndexType)update.getIndex()).getStoreName();
            if (update.isAddition()) {
                itx.add(indexStore, (String)update.getKey(), (IndexEntry)update.getEntry(), update.getElement().isNew());
                continue;
            }
            itx.delete(indexStore, (String)update.getKey(), ((IndexEntry)update.getEntry()).field, ((IndexEntry)update.getEntry()).value, update.getElement().isRemoved());
        }
        return new ModificationSummary(!mutations.isEmpty(), has2iMods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Collection<InternalRelation> addedRelations, Collection<InternalRelation> deletedRelations, StandardJanusGraphTx tx) {
        block35: {
            if (addedRelations.isEmpty() && deletedRelations.isEmpty()) {
                return;
            }
            log.debug("Saving transaction. Added {}, removed {}", (Object)addedRelations.size(), (Object)deletedRelations.size());
            if (!tx.getConfiguration().hasCommitTime()) {
                tx.getConfiguration().setCommitTime(this.times.getTime());
            }
            Instant txTimestamp = tx.getConfiguration().getCommitTime();
            long transactionId = this.txCounter.incrementAndGet();
            if (!tx.getConfiguration().hasAssignIDsImmediately()) {
                this.idAssigner.assignIDs(addedRelations);
            }
            BackendTransaction mutator = tx.getTxHandle();
            boolean acquireLocks = tx.getConfiguration().hasAcquireLocks();
            boolean hasTxIsolation = this.backend.getStoreFeatures().hasTxIsolation();
            boolean logTransaction = this.config.hasLogTransactions() && !tx.getConfiguration().hasEnabledBatchLoading();
            KCVSLog txLog = logTransaction ? this.backend.getSystemTxLog() : null;
            TransactionLogHeader txLogHeader = new TransactionLogHeader(transactionId, txTimestamp, this.times);
            try {
                ModificationSummary commitSummary;
                if (logTransaction) {
                    Preconditions.checkNotNull((Object)txLog, (Object)"Transaction log is null");
                    txLog.add(txLogHeader.serializeModifications(this.serializer, LogTxStatus.PRECOMMIT, tx, addedRelations, deletedRelations), txLogHeader.getLogKey());
                }
                boolean hasSchemaElements = !Iterables.isEmpty((Iterable)Iterables.filter(deletedRelations, SCHEMA_FILTER)) || !Iterables.isEmpty((Iterable)Iterables.filter(addedRelations, SCHEMA_FILTER));
                Preconditions.checkArgument((!hasSchemaElements || !tx.getConfiguration().hasEnabledBatchLoading() && acquireLocks ? 1 : 0) != 0, (Object)"Attempting to create schema elements in inconsistent state");
                if (hasSchemaElements && !hasTxIsolation) {
                    BackendTransaction schemaMutator = this.openBackendTransaction(tx);
                    try {
                        commitSummary = this.prepareCommit(addedRelations, deletedRelations, SCHEMA_FILTER, schemaMutator, tx, acquireLocks);
                        assert (commitSummary.hasModifications && !commitSummary.has2iModifications);
                    }
                    catch (Throwable e) {
                        schemaMutator.rollback();
                        throw e;
                    }
                    try {
                        schemaMutator.commit();
                    }
                    catch (Throwable e) {
                        log.error("Could not commit transaction [" + transactionId + "] due to storage exception in system-commit", e);
                        throw e;
                    }
                }
                commitSummary = this.prepareCommit(addedRelations, deletedRelations, hasTxIsolation ? NO_FILTER : NO_SCHEMA_FILTER, mutator, tx, acquireLocks);
                if (commitSummary.hasModifications) {
                    boolean hasSecondaryPersistence;
                    String logTxIdentifier = tx.getConfiguration().getLogIdentifier();
                    boolean bl = hasSecondaryPersistence = logTxIdentifier != null || commitSummary.has2iModifications;
                    if (logTransaction) {
                        txLog.add(txLogHeader.serializePrimary(this.serializer, hasSecondaryPersistence ? LogTxStatus.PRIMARY_SUCCESS : LogTxStatus.COMPLETE_SUCCESS), txLogHeader.getLogKey(), (ExternalPersistor)mutator.getTxLogPersistor());
                    }
                    try {
                        mutator.commitStorage();
                    }
                    catch (Throwable e) {
                        log.error("Could not commit transaction [" + transactionId + "] due to storage exception in commit", e);
                        throw e;
                    }
                    if (hasSecondaryPersistence) {
                        LogTxStatus status = LogTxStatus.SECONDARY_SUCCESS;
                        Object indexFailures = ImmutableMap.of();
                        boolean userlogSuccess = true;
                        try {
                            indexFailures = mutator.commitIndexes();
                            if (!indexFailures.isEmpty()) {
                                status = LogTxStatus.SECONDARY_FAILURE;
                                for (Map.Entry entry : indexFailures.entrySet()) {
                                    log.error("Error while committing index mutations for transaction [" + transactionId + "] on index: " + (String)entry.getKey(), (Throwable)entry.getValue());
                                }
                            }
                            if (logTxIdentifier == null) break block35;
                            try {
                                userlogSuccess = false;
                                Log userLog = this.backend.getUserLog(logTxIdentifier);
                                Future<Message> env = userLog.add(txLogHeader.serializeModifications(this.serializer, LogTxStatus.USER_LOG, tx, addedRelations, deletedRelations));
                                if (env.isDone()) {
                                    try {
                                        env.get();
                                    }
                                    catch (ExecutionException ex) {
                                        throw ex.getCause();
                                    }
                                }
                                userlogSuccess = true;
                            }
                            catch (Throwable e) {
                                status = LogTxStatus.SECONDARY_FAILURE;
                                log.error("Could not user-log committed transaction [" + transactionId + "] to " + logTxIdentifier, e);
                            }
                            break block35;
                        }
                        finally {
                            if (logTransaction) {
                                try {
                                    txLog.add(txLogHeader.serializeSecondary(this.serializer, status, (Map<String, Throwable>)indexFailures, userlogSuccess), txLogHeader.getLogKey());
                                }
                                catch (Throwable e) {
                                    log.error("Could not tx-log secondary persistence status on transaction [" + transactionId + "]", e);
                                }
                            }
                        }
                    }
                    mutator.commitIndexes();
                    break block35;
                }
                mutator.commit();
            }
            catch (Throwable e) {
                log.error("Could not commit transaction [" + transactionId + "] due to exception", e);
                try {
                    mutator.rollback();
                }
                catch (Throwable e2) {
                    log.error("Could not roll-back transaction [" + transactionId + "] after failure due to exception", e2);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new JanusGraphException("Unexpected exception", e);
            }
        }
    }

    static {
        TraversalStrategies graphStrategies = TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone().addStrategies(new TraversalStrategy[]{AdjacentVertexFilterOptimizerStrategy.instance(), AdjacentVertexHasIdOptimizerStrategy.instance(), AdjacentVertexIsOptimizerStrategy.instance(), JanusGraphLocalQueryOptimizerStrategy.instance(), JanusGraphStepStrategy.instance(), JanusGraphIoRegistrationStrategy.instance()});
        TraversalStrategies.GlobalCache.registerStrategies(StandardJanusGraph.class, (TraversalStrategies)graphStrategies);
        TraversalStrategies.GlobalCache.registerStrategies(StandardJanusGraphTx.class, (TraversalStrategies)graphStrategies);
        SCHEMA_FILTER = internalRelation -> internalRelation.getType() instanceof BaseRelationType && internalRelation.getVertex(0) instanceof JanusGraphSchemaVertex;
        NO_SCHEMA_FILTER = internalRelation -> !SCHEMA_FILTER.apply(internalRelation);
        NO_FILTER = Predicates.alwaysTrue();
    }

    private static class ShutdownThread
    extends Thread {
        private final StandardJanusGraph graph;

        public ShutdownThread(StandardJanusGraph graph) {
            this.graph = graph;
        }

        @Override
        public void start() {
            log.debug("Shutting down graph {} using shutdown hook {}", (Object)this.graph, (Object)this);
            this.graph.closeInternal();
        }
    }

    private static class ModificationSummary {
        final boolean hasModifications;
        final boolean has2iModifications;

        private ModificationSummary(boolean hasModifications, boolean has2iModifications) {
            this.hasModifications = hasModifications;
            this.has2iModifications = has2iModifications;
        }
    }
}

