/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Map;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.ReadBuffer;
import org.janusgraph.diskstorage.ScanBuffer;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.graphdb.database.idhandling.VariableLong;
import org.janusgraph.graphdb.database.serialize.DataOutput;
import org.janusgraph.graphdb.database.serialize.Serializer;

public class BufferUtil {
    public static final int longSize = 8;
    public static final int intSize = 4;

    public static StaticBuffer getIntBuffer(int id) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(id);
        byte[] arr = buffer.array();
        Preconditions.checkArgument((arr.length == 4 ? 1 : 0) != 0);
        return StaticArrayBuffer.of(arr);
    }

    public static StaticBuffer getIntBuffer(int[] ids) {
        ByteBuffer buffer = ByteBuffer.allocate(4 * ids.length);
        for (int id : ids) {
            buffer.putInt(id);
        }
        byte[] arr = buffer.array();
        Preconditions.checkArgument((arr.length == 4 * ids.length ? 1 : 0) != 0);
        return StaticArrayBuffer.of(arr);
    }

    public static StaticBuffer getLongBuffer(long id) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(id);
        byte[] arr = buffer.array();
        Preconditions.checkArgument((arr.length == 8 ? 1 : 0) != 0);
        return StaticArrayBuffer.of(arr);
    }

    public static StaticBuffer fillBuffer(int len, byte value) {
        byte[] res = new byte[len];
        for (int i = 0; i < len; ++i) {
            res[i] = value;
        }
        return StaticArrayBuffer.of(res);
    }

    public static StaticBuffer oneBuffer(int len) {
        return BufferUtil.fillBuffer(len, (byte)-1);
    }

    public static StaticBuffer zeroBuffer(int len) {
        return BufferUtil.fillBuffer(len, (byte)0);
    }

    public static StaticBuffer emptyBuffer() {
        return BufferUtil.fillBuffer(0, (byte)0);
    }

    public static void writeEntry(DataOutput out, Entry entry) {
        VariableLong.writePositive(out, entry.getValuePosition());
        BufferUtil.writeBuffer(out, entry);
        if (!entry.hasMetaData()) {
            out.putByte((byte)0);
        } else {
            Map<EntryMetaData, Object> metadata = entry.getMetaData();
            assert (metadata.size() > 0 && metadata.size() < 127);
            assert (EntryMetaData.values().length < 127);
            out.putByte((byte)metadata.size());
            for (Map.Entry<EntryMetaData, Object> metas : metadata.entrySet()) {
                EntryMetaData meta = metas.getKey();
                out.putByte((byte)meta.ordinal());
                out.writeObjectNotNull(metas.getValue());
            }
        }
    }

    public static void writeBuffer(DataOutput out, StaticBuffer buffer) {
        VariableLong.writePositive(out, buffer.length());
        out.putBytes(buffer);
    }

    public static Entry readEntry(ReadBuffer in, Serializer serializer) {
        long valuePosition = VariableLong.readPositive(in);
        Preconditions.checkArgument((valuePosition > 0L && valuePosition <= Integer.MAX_VALUE ? 1 : 0) != 0);
        StaticBuffer buffer = BufferUtil.readBuffer(in);
        StaticArrayEntry entry = new StaticArrayEntry(buffer, (int)valuePosition);
        int metaSize = in.getByte();
        for (int i = 0; i < metaSize; ++i) {
            EntryMetaData meta = EntryMetaData.values()[in.getByte()];
            entry.setMetaData(meta, serializer.readObjectNotNull(in, meta.getDataType()));
        }
        return entry;
    }

    public static StaticBuffer readBuffer(ScanBuffer in) {
        long length = VariableLong.readPositive(in);
        Preconditions.checkArgument((length >= 0L && length <= Integer.MAX_VALUE ? 1 : 0) != 0);
        byte[] data = in.getBytes((int)length);
        assert ((long)data.length == length);
        return new StaticArrayBuffer(data);
    }

    public static StaticBuffer padBuffer(StaticBuffer b, int length) {
        if (b.length() >= length) {
            return b;
        }
        byte[] data = new byte[length];
        for (int i = 0; i < b.length(); ++i) {
            data[i] = b.getByte(i);
        }
        return new StaticArrayBuffer(data);
    }

    public static StaticBuffer nextBiggerBufferAllowOverflow(StaticBuffer buffer) {
        return BufferUtil.nextBiggerBuffer(buffer, true);
    }

    public static StaticBuffer nextBiggerBuffer(StaticBuffer buffer) {
        return BufferUtil.nextBiggerBuffer(buffer, false);
    }

    private static StaticBuffer nextBiggerBuffer(StaticBuffer buffer, boolean allowOverflow) {
        int len = buffer.length();
        byte[] next = new byte[len];
        boolean carry = true;
        for (int i = len - 1; i >= 0; --i) {
            byte b = buffer.getByte(i);
            if (carry && (b = (byte)(b + 1)) != 0) {
                carry = false;
            }
            next[i] = b;
        }
        if (carry && allowOverflow) {
            return BufferUtil.zeroBuffer(len);
        }
        if (carry) {
            throw new IllegalArgumentException("Buffer overflow incrementing " + buffer);
        }
        return StaticArrayBuffer.of(next);
    }

    public static boolean equals(StaticBuffer b1, ByteBuffer b2) {
        if (b1.length() != b2.remaining()) {
            return false;
        }
        int p2 = b2.position();
        for (int i = 0; i < b1.length(); ++i) {
            if (b1.getByte(i) == b2.get(p2 + i)) continue;
            return false;
        }
        return true;
    }
}

